
// File qdvdauthorinit.h

#ifndef QDVDAUTHORINIT_H
#define QDVDAUTHORINIT_H

// This is the version number for the Init-file
#define INIT_VERSION  1.5

#define AUTOSAVE_FILE_NAME "/.qdvdauthor/autosave.xml"
#define INIT_DIR_NAME  "/.qdvdauthor/"
#define INIT_FILE_NAME "qdvdauthor.ini"

#define INIT_DOCTYPE           ""
#define TAG_INIT               "QDVDAuthorInitFile"
#define TAG_PREFERRED_ENGINE   "PreferredEngine"
#define TAG_EXTERNAL_PLAYER    "ExternalPlayer"
#define TAG_COLOR              "Color"
#define TAG_PATH               "Path"
#define TAG_HISTORY            "History"
#define TAG_EXECUTE            "ExecuteInterface"
#define TAG_CONVERT            "Convert"
#define TAG_PAL                "Pal"
#define TAG_NTSC               "Ntsc"
#define TAG_DVDAUTHOR          "Dvdauthor"
#define TAG_BURNING            "Burning"
#define TAG_BLOCK              "Block"
#define TAG_SUBBLOCK           "SubBlock"
#define TAG_COMMAND            "Command"
#define TAG_COMMENT            "Comment"
#define TAG_DRAGNDROP          "DragNDrop"
#define TAG_FONT               "Font"

#define ATTRIB_DND_THUMBNAIL   "thumbnail_size"
#define ATTRIB_DND_BUTTON      "button_size"
#define ATTRIB_DND_BUTTON_TYPE "button_type"
#define ATTRIB_DND_WITH_TEXT   "with_text"
#define ATTRIB_DND_TEXT_POS    "text_pos"
#define ATTRIB_DND_START       "start_offset"
#define ATTRIB_DND_DURATION    "duration"
#define ATTRIB_DND_COLOR       "color"
#define ATTRIB_DND_START_WHEN  "start_when"
#define ATTRIB_DND_NICE        "nice"

#define ATTRIB_VERSION           "version"
#define ATTRIB_STYLE             "style"
#define ATTRIB_AUTOSAVE          "autosave"
#define ATTRIB_ACTIVE            "active"
#define ATTRIB_MAX_HISTORY       "max_history"
#define ATTRIB_MAX_THREADS       "max_threads"
#define ATTRIB_DELETE_OLDER_THAN "delete_older_than"
#define ATTRIB_VISIBLE_REGION    "visible_region"
#define ATTRIB_NUMBER            "number"
#define ATTRIB_HIDDEN            "hidden"
#define ATTRIB_EDITABLE          "editable"
#define ATTRIB_CANMODIFY         "canmodify"
#define ATTRIB_NAME              "name"
#define ATTRIB_COLOR             "color"
#define ATTRIB_DEFAULT           "default"
#define ATTRIB_BLOCKNAME         "blockname"

#define BLOCK_MOVIE_CONVERT    "MOVIE_CONVERT"
#define BLOCK_AUDIO_CONVERT    "AUDIO_CONVERT"
#define BLOCK_MOVIE_BACKGROUND "MOVIE_BACKGROUND"
#define BLOCK_IMAGE_BACKGROUND "IMAGE_BACKGROUND"
#define BLOCK_EMPTY_SOUND      "EMPTY_SOUND"
#define BLOCK_MPLEX            "MPLEX"
#define BLOCK_SPUMUX           "SPUMUX"
#define BLOCK_OTHERS           "OTHERS"
#define SUB_BLOCK_TRANSCODE    "Transcode"
#define SUB_BLOCK_MENCODER     "MEncoder"

#include "dvdmenu.h"
#include "dialogexecute.h"	// get the definition of class ExecuteInterface
#include "utils.h"

class DragnDropContainer;
class SourceFileEntry;

class QDVDAuthorInit
{
private:
	class MenuBlock {
		public:
			class SubBlock;
			class Block
			{
				public:
				 Block ()
					{ iDefaultCommand = 0; iBlockID = -1; iActive = -1; bHidden = false; bEditable = true;};
				~Block ()
					{ for (uint t=0;t<listSubBlocks.count();t++) delete listSubBlocks[t]; };
				QString     qsBlockTag;
				int         iActive;
				int         iBlockID;
				int         iDefaultCommand;
				bool        bHidden;
				bool        bEditable;
				QStringList listComments;
				QStringList listCommands;
				QValueList<SubBlock *>listSubBlocks;
			};
			class SubBlock
			{
				public:
				 SubBlock () { iNumber=0; };
				~SubBlock () { for (uint t=0;t<listBlocks.count();t++) delete listBlocks[t];};
				QString     qsName;	// Name. E.g. Transcode
				int         iNumber;	// running number starting from 0. In case we need to sort it.
				QValueList<Block *>listBlocks;
			};
			MenuBlock ();

			QString qsMenuTag;      // Holds the ID to indicate which MenuBlock it is (E.g. TAG_CONVERT).
			bool    bValid;         // 
			bool    bHidden;        // Should this MenuBlock be hidden initially ?
			QString qsBlockName;    // The name of the MenuBlock (E.g. Main Menu VMGM (widthxheight))
			QColor  colorBackground;

			Block   blockMovieBackground;
			Block   blockImageBackground;
			Block   blockEmptySound;
			Block   blockMplex;
			Block   blockSpumux;
			Block   blockOthers;
	};

public:
	 QDVDAuthorInit ();
	 QDVDAuthorInit (DragNDropContainer *);
	 QDVDAuthorInit (QValueList<Utils::toolsPaths *>&, DragNDropContainer *);
	~QDVDAuthorInit ();

	QString preferredEngine ();
	bool    visibleRegion   ();
	void setToolsPaths (QValueList<Utils::toolsPaths *>&);
	QValueList <Utils::toolsPaths *> &getToolsPaths    ();
	QValueList <ExecuteInterface *>  &getList          ();
	QStringList                       getHistory       ();
	QValueList<QPixmap *>             getHistoryPix    ();
	int                               maxHistoryFiles  ();
	int                               getAutosave      ();
	QString                           getStyle         ();
	void setStyle            (QString);
	void setAutosave         (int);
	void setVisibleRegion    (bool);
	void setHistory          (int, QStringList, QValueList<QPixmap *>);
	void appendPreProcessing ();
	void appendConvert       (SourceFileEntry *);
	void appendMenu          (DVDMenu *, QString, QString);
	void appendPostProcessing();
	bool readIniFile         ();
	bool saveIniFile         ();
	void setDefault          (int, uint);
	QDVDAuthorInit::MenuBlock::Block *getBlock ( int );
//	QString resolvTranscodingString        ( QString );
	QString resolvString                   ( QString );
	QString resolvConvert           (QString, QString);
	void setKeywords            (QValueList <QString>);
	QStringList getKeys           (MenuBlock::Block *);

private:	// private functions.
	bool    initMe ();
	void    addBlock      (ExecuteInterface *, MenuBlock::Block *);
	bool    readBlock     (MenuBlock::Block *, QDomElement *);
	bool    readSubBlock  (MenuBlock::SubBlock *, QDomElement *pElem);
	bool    readMenuBlock (MenuBlock *, QDomElement *);
	bool    saveMenuBlock (MenuBlock *, QDomElement *);
	bool    saveBlock     (MenuBlock::Block *, QDomElement *);
	bool    saveSubBlock  (MenuBlock::SubBlock *, QDomElement *);
	int     printBlock    (MenuBlock::Block *, int i=0);
//	bool    saveSubBlock (MenuBlock::Block *, QDomElement *, bool);
	QString convertSoundFile (QString);
	void    resetInitFile ();
	void    mergeToolsPaths (QValueList<Utils::toolsPaths *>);

private:	// private variables
	QString              m_qsPreferredEngine;
	bool                 m_bVisibleRegion;
	bool                 m_bProtectToolsObjects;
	int                  m_iCurrentBlockID;
	QString              m_qsTempPath;
	QString              m_qsStyle;
	QString              m_qsProjectPath;
	QString              m_qsDvdauthorFile;
	QStringList          m_listKeywords;
	QValueList<QColor *> m_arrayColors;
	int                  m_iColorCounter;
	MenuBlock            m_convertMenuBlock;
	MenuBlock            m_palMenuBlock;
	MenuBlock            m_ntscMenuBlock;
	MenuBlock            m_dvdauthorMenuBlock;
	MenuBlock            m_burningMenuBlock;
	QStringList          m_listHistory;	   // History Project files ...
	QValueList<QPixmap *>m_listHistoryPix;	   // History Project file Icons ...
	bool                 m_bOwnerOfHistoryPix; // indicates if we have ownership and thus should delete the objects at exit ...
	int                  m_iMaxHistoryFiles;
	int                  m_iAutosave;
	QStringList          m_soundList;
	QStringList          m_listKeys;
	QStringList          m_listTranscodeKeys;
	// Pre processing steps
	ExecuteInterface m_convertInterface;

	// Post processing steps
	ExecuteInterface m_dvdauthorInterface;
	ExecuteInterface m_burnInterface;

	// The full list of commands to execute ...
	QValueList <ExecuteInterface *>  m_listExecute;
	QValueList <ExecuteInterface *>  m_listToBeDeleted;
	QValueList <Utils::toolsPaths *> m_listToolsPaths;
	DragNDropContainer              *m_pDragNDropContainer;
	
	friend class DialogCommandEditor;
	friend class DialogExecute;
};

#endif // QDVDAUTHORINIT_H

/* File structure :
XML
-- Definition :
	+WIDTH+                = Background Width
	+HEIGHT+               = Background Height
	+FORMAT+               = "PAL" or "NTSC"
	+MENU_NAME+            = E.g. Main Menu VMGM
	+BACKGROUND_FILE_NAME+ = E.g. Main Menu VMGMbackground.jpg
	+BACKGROUND_FULL_NAME+ = E.g. /tmp/Unnamed/Main Menu VMGMbackground.jpg
	+TEMP_PATH+            = E.g. /tmp
	+SOUND_LIST+           = All sound files in mp2 format (including \" - characters !)
	                         E.g. \"sound1.mp2\" \"sound2.mp2\"
	+DVDAUTHOR_XML+        = E.g. /tmp/dvdauthor.xml
	+PROJECT_PATH+         = Where the DVD filestructure will be created (E.g. /tmp/myDVD/dvd)

		arrayColors[0] = QColor (158,238,129); //
	arrayColors[1] = QColor (143,238,211); //
	arrayColors[2] = QColor (224,238,143); // #E0EE8F
	arrayColors[3] = QColor (237,151,238); // #ED97EE
	arrayColors[4] = QColor (158,238,129); // #9EEE81
	arrayColors[5] = QColor (143,238,211); // #8FEED3
	arrayColors[6] = QColor (224,238,143); // #E0EE8F
	arrayColors[7] = QColor (237,151,238); // #ED97EE
	arrayColors[8] = QColor (158,238,129); // #9EEE81
	arrayColors[9] = QColor (143,238,211); // #8FEED3
	arrayColors[10]= QColor (224,238,143); // #E0EE8F
	arrayColors[11]= QColor (249,47,94);   // #F92F5E

Following is the default init file ...
<QDVDAuthorInitFile>
  <Color number="0">#9EEE81</Color>
  <Color number="1">#8FEED3</Color>
  <Color number="2">#E0EE8F</Color>
  <Color number="3">#ED97EE</Color>
  <Color number="4">#9EEE81</Color>
  <Color number="5">#8FEED3</Color>
  <Color number="6">#E0EE8F</Color>
  <Color number="7">#ED97EE</Color>
  <Color number="8">#9EEE81</Color>
  <Color number="9">#8FEED3</Color>
  <Color number="10">#E0EE8F</Color>
  <Color number="11">#F92F5E</Color>
  <ExecuteInterface>
    <Convert blockname="Convert" color="#F92F5E">
      <Block name="MOVIE_CONVERT">
        <Comment><p align=\"center\">This will convert the input movie file from DV - format into DVD conform material.</p></Comment>
        <Command>transcode -i mindfields_low_osx.avi -x ffmpeg -V -w 8500 --encode_fields b --export_asr 2 -F 8,-c -q 6 -4 2 -2 1 -N 0.5 -E -10 -K tmpgenc -R 2 -y mpeg2enc,mp2enc -b 224 -m mindfields_out_dvd.mpg -o mindfields_out_dvd.mpg --print_status 10</Command>
        <Comment><p align=\"center\">This will convert the input movie file from mpeg1 - format into DVD conform material.</p></Comment>
        <Command>transcode -i mindfields_low_osx.avi -x ffmpeg -V -w 8500 --encode_fields b --export_asr 2 -F 8,-c -q 6 -4 2 -2 1 -N 0.5 -E -10 -K tmpgenc -R 2 -y mpeg2enc,mp2enc -b 224 -m mindfields_out_dvd.mpg -o mindfields_out_dvd.mpg --print_status 10</Command>
      </Block>
      <Block name="AUDIO_CONVERT">
        <Comment><p align=\"center\">We need to convert from OGG-Vorbis format to mp2.</p></Comment>
        <Command>oggdec test.ogg -o - | mp2enc -o test2.mp2</Command>
        <Comment><p align=\"center\">We need to convert from mp3 format to mp2.</p></Comment>
        <Command>lame --decode blues.mp3 - | mp2enc -o blues.mp2</Command>
        <Command>mplayer mymusicfile.mp3 -vo null -ao pcm -aofile menu_audio.pcm ; mp2enc -r 48000 -o menu_audio.mpa &lt; menu_audio.pcm</Command>
      </Block>
    </Convert>
  </ExecuteInterface>
  <ExecuteInterface>
    <Pal blockname="+MENU_NAME+ (PAL +WIDTH+x+HEIGHT+)" color="#9EEE81">
      <Block name="MOVIE_BACKGROUND">
        <Comment><p align=\"center\">This line of command will convert the background movie<BR>into a MPEG2 stream in PAL format +WIDTH+x+HEIGHT+</p></Comment>
        <Command default="true">transcode -i -V -J fps 25 --export_asr 2 --keep_asr -Z +WIDTH+x+HEIGHT+ -y jpg,wav -m +TEMP_PATH+/audio+MENU_NAME+.wav -o background+MENU_NAME+</Command>
      </Block>
      <Block name="IMAGE_BACKGROUND">
        <Comment><p align=\"center\">This line of command will convert the background image<BR>into a MPEG2 stream in PAL format +WIDTH+x+HEIGHT+</p></Comment>
        <Command>jpegtopnm \"+BACKGROUND_FILE_NAME+\" | ppmtoy4m -n 1 -F25:1 -A59:54 -I t -L | mpeg2enc -f 8 -n p -o \"+MENU_NAME+.m2v\"<Command>
        <Command default="true">jpeg2yuv -n 50 -I p -f 25 -j \"+BACKGROUND_FILE_NAME+\" | mpeg2enc -n p -f 8 -o \"+MENU_NAME+.m2v\"</Command>
      </Block>
      <Block name="EMPTY_SOUND">
        <Comment><p align=\"center\">This line creates an empty sound file to mix into the menu-movie.</P></Comment>
        <Command>arecord -f dat -twav -d 1 /dev/stdout | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>sox -t raw -s -w -c 2 -r 48000 /dev/zero -t wav -c 2 -r 48000 /dev/stdout trim 0 1 | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command default="true">dd if=/dev/zero bs=4 count=1920 | toolame -b128 -s 48 /dev/stdin \"+MENU_NAME+.mp2\"</Command>
      </Block>
      <Block name="MPLEX">
        <Comment><p align=\"center\">The following command will multiplex the sound file into the menu-movie.</p></Comment>
        <Command default="true">mplex -f 8 -o \"+MENU_NAME+.mpg\" \"+MENU_NAME+.m2v\" +SOUND_LIST+</Command>
      </Block>
      <Block name="SPUMUX">
        <Comment><p align=\"center\">Here we use spumux to add the subpicture (buttons) the the mpeg2 video.</p></Comment>
        <Command default="true">spumux \"+MENU_NAME+.xml\" < \"+MENU_NAME+.mpg\" > \"+MENU_NAME+_menu.mpg\"</Command>
      </Block>
    </Pal>
    <Ntsc blockname=" (NTSC +WIDTH+x+HEIGHT+)" backgroundcolor="1">
      <Block name="MOVIE_BACKGROUND">
        <Comment><p align=\"center\">This line of command will convert the background movie<BR>into a MPEG2 stream in NTSC format +WIDTH+x+HEIGHT+</p></Comment>
        <Command default="true">transcode -i -V -J fps 29.970 --export_asr 2 --keep_asr -Z +WIDTH+x+HEIGHT+ -y jpg,wav -m +TEMP_PATH+/audio+MENU_NAME+.wav -o background+MENU_NAME+</Command>
      </Block>      
      <Block name="IMAGE_BACKGROUND">
        <Comment><p align=\"center\">This line of command will convert the background image<BR>into a MPEG2 stream in NTSC format +WIDTH+x+HEIGHT+</p></Comment>
        <Command>jpegtopnm \"+BACKGROUND_FILE_NAME+\" | ppmtoy4m -n 1 -F30000:1001 -A10:11 -I t -L | mpeg2enc -f 8 -n n -o \"+MENU_NAME.m2v\"</Command>
        <Command default="true">jpeg2yuv -n 50 -I p -f 29.97 -j \"+BACKGROUND_FILE_NAME+\" | mpeg2enc -n n -f 8 -o \"+MENU_NAME+.m2v\"</Command>
      </Block>
      <Block name=EMPTY_SOUND">
        <Comment><p align=\"center\">This line creates an empty sound file to mix into the menu-movie.</P></Comment>
        <Command default="true">arecord -f dat -twav -d 1 /dev/stdout | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>sox -t raw -s -w -c 2 -r 48000 /dev/zero -t wav -c 2 -r 48000 /dev/stdout trim 0 1 | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>dd if=/dev/zero bs=4 count=1601.6 | toolame -b128 -s 48 /dev/stdin \"+MENU_NAME+.mp2\"</Command>
      </Block>
      <Block name="MPLEX">
        <Comment><p align=\"center\">The following command will multiplex the sound file into the menu-movie.</p></Comment>
        <Comman default="true"d>mplex -f 8 -o \"+MENU_NAME+.mpg\" \"+MENU_NAME+.m2v\" +SOUND_LIST+</Command>
      </Block>
      <Block name="SPUMUX">
        <Comment><p align=\"center\">Here we use spumux to add the subpicture (buttons) the the mpeg2 video.</p></Comment>
        <Command default="true">spumux \"+MENU_NAME+.xml\" < \"+MENU_NAME+.mpg\" > \"+MENU_NAME+_menu.mpg\"</Command>
      </Block>
    </Ntsc>
  </ExecuteInterface>
  <ExecuteInterface>
    <Dvdauthor blockname="dvdauthor" color="#F92F5E">
      <Block>
        <Comment>Here we start dvdauthor with the generated xml file.</Comment>
        <Command>dvdauthor -x \"+DVDAUTHOR_XML+\"</Command>
      </Block>
    </Dvdauthor>
  </ExecuteInterface>
  <ExecuteInterface hidden="true">
    <Burning blockname="Burn DVD">
      <Block>
        <Comment>Last we burn the DVD.</Comment>
        <Command>growisofs -Z /dev/dvd -dvd-video +PROJECT_PATH+/</Command>
        <Comment>This command will format a empty -RW DVD (only needed for older drives).</Comment>
        <Command>dvd+rw-format -f /dev/srcd0</Command>
        <Comment>This command generates an iso image of the DVD.</Comment>
        <Command>mkisofs -dvd-video -udf -o +TEMP_PATH+/dvd.iso +PROJECT_PATH+/</Command>
        <Comment>This command burns the iso DVD image to DVD</Comment>
        <Command>dvdrecord -dao speed=2 dev=0,0,0 +TEMP_PATH+/dvd.iso</Command>
      </Block>
    </Burning>
  </ExecuteInterface>
</QDVDAuthorInitFile>
*/

