#!/bin/bash

# First we clean up a little ...
./clean.sh

# Here we get the version number from the SPEC file.
version=`cat qdvdauthor.spec | grep Version | awk '{ print $2;}' | tr -d "\r\n"`
echo "$version"

// now we create the directory
cd ..
mkdir qdvdauthor-$version
cp -R qdvdauthor/* qdvdauthor-$version/

# Finally we create the tarball
tar -czf qdvdauthor-$version.tar.gz qdvdauthor-$version


