/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Dec 14 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef BUTTONPREVIEW_H
#define BUTTONPREVIEW_H

#include <qlabel.h>
//#include <qvaluelist.h>
#include <qptrlist.h>
#include <qpixmap.h>

#include "menuobject.h"

class QDomNode;
class QDomElement;

class ButtonPreview : public QLabel
{
	Q_OBJECT
public:
	 ButtonPreview (QWidget * parent, const char * name = 0, WFlags f = 0 );
	~ButtonPreview ();

	void toTop (MenuObject *);

	void addMenuObject(MenuObject *);
	void setViewport(QRect &);
	MenuObject *childContains (QPoint &);
	MenuObject *menuObject (uint);
	uint objectCount();
	void updatePixmap ();
	void setCurrentPath(QString &);
	
public slots:	
	virtual void slotDeleteObject   (MenuObject *);
	virtual void setPixmap (const QPixmap &);

protected:
	virtual void mousePressEvent		(QMouseEvent *);
	virtual void mouseReleaseEvent		(QMouseEvent *);
	virtual void mouseDoubleClickEvent	(QMouseEvent *);

	virtual void drawContents (QPainter *);

protected:
	QPtrList<MenuObject>	 m_listMenuObjects;
	QRect m_rectViewport;		// This is the viewport set in drawContents()
	QPixmap m_backgroundPixmap;
	MenuObject *m_pActiveObject;
	// tells the process to skip further handling of the MouseEvents since they were already taken care of.
	bool m_bMouseEventDone;
	QString m_qsCurrentPath;
};

// I NEVER rely on my own memory, as I have determined that is not only faulty, but actively working against me.
// ROFL @ http://www.sysadminco.com/

#endif // BUTTONPREVIEW_H
