/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Feb 23 21:45:00 2004
**      by: Varol Okan using kate editor
**
**  pure virtual class as base for the three button types.
**
****************************************************************************/

#ifndef FRAMEOBJECT_H
#define FRAMEOBJECT_H

#include <qpixmap.h>
#include "menuobject.h"


class FrameObject : public MenuObject
{
	Q_OBJECT
public:
	// Public functions needed for the abstract base class.
	FrameObject (QWidget *pParent = 0);
	virtual ~FrameObject();
	virtual void drawContents(QPainter *);
	virtual bool mouseMoveEvent        (QMouseEvent *);
	virtual bool mousePressEvent       (QMouseEvent *);
	virtual bool mouseReleaseEvent     (QMouseEvent *);
	virtual bool mouseDoubleClickEvent (QMouseEvent *);

	virtual bool readProjectFile  (QDomNode &);
	virtual bool writeProjectFile (QDomElement &);
	virtual void createStructure (QListViewItem *);
	virtual MenuObject *clone();
	virtual void replaceColor (QColor, QColor);
	
signals:
	void signalDefineAsButton(MenuObject *);
	void signalDeleteMe(MenuObject *);
//	void signalModifyMe(MenuObject *);
	void signalUpdateStructure();

public:
	// Further public functions not dervied from the base class.
	void setFrameWidth(int);
	void setFrameStyle(int);
	void setFrameJoin (int);
	void setFrameColor(QColor);

	int    width ();
	QColor color ();
	int    join  ();
	int    style ();

protected slots:
	virtual void slotEdit();
	virtual void slotMatrix();
	virtual void slotDelete();
	virtual void slotAddText();
	virtual void slotAddImage();
	virtual void slotAddMovie();
	virtual void slotDefineAsButton();

private:
	QColor  m_colorFrame;
	int     m_iFrameWidth;
	int     m_iFrameStyle;
	int     m_iFrameJoin;
};

#endif	// FRAMEOBJECT_H
