
#include <qapplication.h>
#include <qtextcodec.h>
#include <qdir.h>

#include "dvdmenu.h"
#include "qdvdauthor.h"

int main( int argc, char ** argv )
{
	QApplication application( argc, argv );
	// translation file for Qt
	QTranslator qt( 0 );
	// Under $QTDIR/translations/
	qt.load( QString( "qt_" ) + QTextCodec::locale(), "." );
	application.installTranslator( &qt );

	// translation file for my application strings
	QTranslator myapp( 0 );
	// Under ~/.qdvdauthor/
	QDir::home().path();
	myapp.load( QString(QDir::home().path() + "/.qdvdauthor/qdvdauthor_" ) + QTextCodec::locale(), "." );
	application.installTranslator( &myapp );

	QDVDAuthor dvdAuthor;
	VMGMenu *pDVDMenu = new VMGMenu (&dvdAuthor);

	dvdAuthor.addDVDMenu(pDVDMenu, true);
	dvdAuthor.show();
	application.connect( &application, SIGNAL( lastWindowClosed() ), &application, SLOT( quit() ) );
	return application.exec();
}

