/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Dec 14 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef QDVDAUTHOR_H
#define QDVDAUTHOR_H


class QDomNode;
class QDomElement;
class ButtonObject;
class ColorToolBar;
class SourceToolBar;
class StructureToolBar;
class SourceFileEntry;
class QListViewItem;

#include ".ui/formmain.h"
#include <xine.h>

class DVDMenu;
class QListBox;

#define DVDAUTHOR_XML "dvdauthor.xml"

class QDVDAuthor : public CFormMain
{
	Q_OBJECT
public:
	QDVDAuthor ();
	~QDVDAuthor ();

public slots:
	virtual void fileNew();
	virtual void fileOpen();
	virtual void fileSave();
	virtual void fileSaveAs();
	virtual void filePrint();
	virtual void fileExit();
	virtual void editUndo();
	virtual void editRedo();
	virtual void editCut();
	virtual void editPaste();
	virtual void editFind();
	virtual void helpIndex();
	virtual void helpContents();
	virtual void helpAbout();
    
	virtual void slotSetup ();
	virtual void slotExportDVDAuthorXML();
	virtual void slotEditAddMovie ();
	virtual void slotEditAddSlideshow ();
	virtual void slotStructureClicked(QListViewItem*);
	virtual void slotGenerateMasks();
	virtual void slotCreateDVD();
	virtual void slotCreateSVCD();
	virtual void slotCreateVCD();
	virtual void slotAddSubMenu();
	virtual void slotTabChanged (QWidget *);
	virtual void slotRemoveCurrentSubMenu ();
	virtual void slotRenameCurrentSubMenu ();
	virtual void slotUpdateStructure ();
	virtual void slotCreateXml(const QString &);
//	virtual void slotSetSlideshowEntry (QString);
//	virtual void slotSlideshowDone     (QString);

public:
	void addDVDMenu (DVDMenu *, bool b=false);
	void createDvdauthorXml (QString &);
	// The following two functions are currently only used in one function in DVDMenu ...
	int sourceFileCount();
	SourceFileEntry *sourceFileEntry(uint);
	SourceFileEntry *getSourceEntryByDisplayName(QString &);
	void removedSourceEntry (SourceFileEntry *);
	void replaceSourceDisplayName (QString &, QString &);
	bool isSourceEntryUsed(QString &);
	void addSound (QStringList &);
	void setColor (uint, QColor);

	xine_t  *getXineEngine ();
	DVDMenu *getCurrentSubMenu ();
	QValueList<DVDMenu *> &getSubMenus();
	QString &currentPath();
	void setCurrentPath(QString &);
	QString &getTempFile (QString);

	QString getImageFilter ();
	QString getMovieFilter ();
	QString getSoundFilter ();


private: 	// Private functions ...
	void initMe();
	bool initXine ();
	bool cleanUp();
	void LoadIni();
	void SaveIni ();
	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);
	void createDvdauthorXml ();
	void createMenuXml ();
	void createMenuXml (DVDMenu *pMenu);
	void createDVD ();
	QString getButtonAction (ButtonObject *, int, bool b=false);

	bool checkHealth ();

private:
	// This is the main xine engine used everywhere throughout in QDVDAuthor.
	xine_t *m_pXineEngine;
	// Here we store the path to the different tools required.
	QString m_qsDVDAuthorPath;
	QString m_qsMpegToolsPath;
	QString m_qsTempPath;

	DVDMenu *m_pVMGMenu;
	QValueList<DVDMenu *>	m_listDVDMenus;
	// Project File Name can differ from the Project Name...
	QString m_qsProjectFileName;
	QString m_qsProjectName;

	ColorToolBar      *m_pColorToolbar;
	SourceToolBar     *m_pSourceToolbar;
	StructureToolBar  *m_pStructureToolbar;
	bool m_bModified;
	QString m_qsProjectPath;
	QString m_qsCurrentPath;
};

#endif // QDVDAUTHOR_H
