unix {
  UI_DIR = .ui
  MOC_DIR = .moc
  OBJECTS_DIR = .obj
}

# Now we parse the env varaible IMAGE_LIB (set in the configurator GUI)
WHICH_VIDEO_LIB = $$(VIDEO_LIB)
WHICH_QT_LIB = $$(QT_LIB)
WHICH_PREFIX = $$(PREFIX)
WHICH_DEBUG = $$(DEBUG_QDVDAUTHOR)

isEmpty(WHICH_VIDEO_LIB) {
	exists (../bin/confiugrator)	{
		system (../bin/configurator &)
	} else {
		system (cd ..; configure &)
	}
	error ( "Please use configurator or set all neccesary environment variables before calling qmake" )
}

contains( WHICH_VIDEO_LIB, xine) {
	LIBS +=`xine-config --cflags --libs`
}
contains( WHICH_VIDEO_LIB, mplayer) {
	LIBS +=`xine-config --cflags --libs`
}

SOURCES	+= main.cpp\
	execute.cpp \
	dvdinfo.cpp  \
	dvdmenu.cpp   \
	dialogman.cpp  \
	qdvdauthor.cpp  \
	menuobject.cpp   \
	textobject.cpp    \
	frameobject.cpp    \
	imageobject.cpp     \
	movieobject.cpp      \
	dialogframe.cpp       \
	menupreview.cpp        \
	buttonobject.cpp\
	dialogbutton.cpp \
	qimagehelper.cpp  \
	colortoolbar.cpp   \
	buttonpreview.cpp   \
	xml_dvdauthor.cpp    \
	dialogexecute.cpp     \
	dialogtextfont.cpp     \
	qdvdauthorinit.cpp      \
	sourcefileentry.cpp      \
	objectcollection.cpp      \
	listboxcolortext.cpp       \
	structuretoolbar.cpp        \
	dialogcommandeditor.cpp      \
	kimageeffect.cpp   \
	sourcetoolbar.cpp   \
	qplayer/listviewfileitem.cpp\
	qplayer/convert.cpp   \
	qplayer/xineinfo.cpp   \
	qplayer/dialogmovie.cpp \
	qplayer/qxinewidget.cpp  \
	qplayer/dialogchapters.cpp\
	qslideshow/soundline.cpp   \
	qslideshow/imageline.cpp    \
	qslideshow/slidertime.cpp    \
	qslideshow/filterline.cpp     \
	qslideshow/dialogfilter.cpp    \
	qslideshow/dialogcreate.cpp     \
	qslideshow/imagepreview.cpp      \
	qslideshow/xml_slideshow.cpp

HEADERS	+= ../bugs_workaround.h \
	global.h \
	xml_dvd.h \
	execute.h  \
	dvdinfo.h   \
	dvdmenu.h    \
	dialogman.h   \
	modifiers.h    \
	qdvdauthor.h    \
	menuobject.h     \
	textobject.h      \
	frameobject.h      \
	imageobject.h       \
	movieobject.h        \
	dialogframe.h         \
	menupreview.h          \
	buttonobject.h\
	dialogbutton.h \
	qimagehelper.h  \
	colortoolbar.h   \
	buttonpreview.h   \
	xml_dvdauthor.h    \
	dialogexecute.h     \
	qdvdauthorinit.h     \
	dialogtextfont.h      \
	sourcefileentry.h      \
	objectcollection.h      \
	listboxcolortext.h       \
	structuretoolbar.h        \
	dialogcommandeditor.h      \
	kimageeffect.h   \
	sourcetoolbar.h   \
	qplayer/convert.h  \
	qplayer/xineinfo.h  \
	qplayer/dialogmovie.h\
	qplayer/qxinewidget.h \
	qplayer/qxine_global.h \
	qplayer/dialogchapters.h\
	qslideshow/soundline.h   \
	qslideshow/imageline.h    \
	qslideshow/slidertime.h    \
	qslideshow/filterline.h     \
	qplayer/listviewfileitem.h   \
	qslideshow/dialogfilter.h     \
	qslideshow/dialogcreate.h      \
	qslideshow/imagepreview.h       \
	qslideshow/xml_slideshow.h

DISTFILES	= xine_lib.inc \
		mplayer_lib.inc \
	../TODO  \
	../README \
	../INSTALL \
	../COPYING  \
	../CHANGELOG \
	../clean.sh   \
	../configure

FORMS	= formmain.ui             \
	qplayer/uidialogmovie.ui   \
	qplayer/uidialogchapters.ui \
	qslideshow/dialogslide.ui    \
	qslideshow/dialogimage.ui     \
	qslideshow/uidialogcreate.ui   \
	dialogsetup.ui\
	dialogmatrix.ui\
	dialogresize.ui \
	dialoggeometry.ui\
	uidialogframe.ui  \
	uidialogbutton.ui  \
	uisourcewidget.ui   \
	uicommandeditor.ui   \
	uidialogtextfont.ui


IMAGES	= ./images/fileopen ./images/filenew images/filesave images/redo images/undo images/print images/editcut \
	images/editcopy images/editpaste images/searchfind images/to_dvd2.png images/to_dvd.png \
	images/text_ccenter.png images/text_center.png images/text_cfit.png images/text_cjustify.png \
	images/text_cleft.png images/text_cright.png images/text_cstrikeout.png images/text_cunderline.png \
	images/text_cvcenter.png images/text_fit.png images/text_justify.png images/text_left.png \
	images/text_right.png images/text_strikeout.png images/text_underline.png images/text_vcenter.png \
	images/checkered.png images/to_vcd.png images/to_svcd.png
# here we include the images from qxine. needs to be done ...
IMAGES	+=	qplayer/images/desktop.png qplayer/images/documents.png qplayer/images/home.png qplayer/images/project.png \
		qplayer/images/root.png qplayer/images/babytux.png qplayer/images/play.png qplayer/images/pause.png \
		qplayer/images/temp.png

contains( WHICH_QT_LIB, qt) {
	contains( WHICH_QT_LIB, qt-mt) {
		CONFIG += qt-mt
	}
		CONFIG += qt
}

isEmpty(WHICH_PREFIX) {
	WHICH_PREFIX +=/usr
}

prefix.path = $${WHICH_PREFIX}/bin
prefix.files = ../bin/qdvdauthor 

i18n.path = $$(HOME)/.qdvdauthor
i18n.files = i18n/*.qm

# here we set the default type ...
isEmpty(WHICH_DEBUG)	{
	WHICH_DEBUG=release
}

TRANSLATIONS    = i18n/qdvdauthor_de.ts 

INSTALLS = prefix i18n
DESTDIR =../bin
TEMPLATE	 = app
CONFIG		+= thread warn_on $${WHICH_DEBUG}
VERSION = 0.0.8
LANGUAGE	 = C++


