
// File qdvdauthorinit.h

#ifndef QDVDAUTHORINIT_H
#define QDVDAUTHORINIT_H

#define INIT_FILE_NAME "/.qdvdauthor/qdvdauthor.ini"

#define INIT_DOCTYPE  ""
#define TAG_INIT      "QDVDAuthorInitFile"
#define TAG_COLOR     "Color"
#define TAG_EXECUTE   "ExecuteInterface"
#define TAG_PAL       "Pal"
#define TAG_NTSC      "Ntsc"
#define TAG_DVDAUTHOR "Dvdauthor"
#define TAG_BURNING   "Burning"
#define TAG_BLOCK     "Block"
#define TAG_COMMAND   "Command"
#define TAG_COMMENT   "Comment"

#define ATTRIB_NUMBER    "number"
#define ATTRIB_HIDDEN    "hidden"
#define ATTRIB_NAME      "name"
#define ATTRIB_COLOR     "color"
#define ATTRIB_DEFAULT   "default"
#define ATTRIB_BLOCKNAME "blockname"

#define BLOCK_MOVIE_BACKGROUND "MOVIE_BACKGROUND"
#define BLOCK_IMAGE_BACKGROUND "IMAGE_BACKGROUND"
#define BLOCK_EMPTY_SOUND      "EMPTY_SOUND"
#define BLOCK_MPLEX            "MPLEX"
#define BLOCK_SPUMUX           "SPUMUX"
#define BLOCK_OTHERS           "OTHERS"

#include "dvdmenu.h"
#include "dialogexecute.h"	// get the definition of class ExecuteInterface

class QDVDAuthorInit
{
private:
	class MenuBlock {
		public:
			class Block
			{
				public:
				Block ()
					{ iDefaultCommand = 0; iBlockID = -1; };
				QString     qsBlockTag;
				int         iBlockID;
				int         iDefaultCommand;
				QStringList listComments;
				QStringList listCommands;
			};
			MenuBlock ();

			QString qsMenuTag;
			bool    bValid;
			bool    bHidden;
			QString qsBlockName;
			QColor  colorBackground;

			Block   blockMovieBackground;
			Block   blockImageBackground;
			Block   blockEmptySound;
			Block   blockMplex;
			Block   blockSpumux;
			Block   blockOthers;
	};
public:
	 QDVDAuthorInit ();
	 QDVDAuthorInit (QString, QString, QString);
	~QDVDAuthorInit ();

	QValueList <ExecuteInterface *>&getList();
	void appendPreProcessing ();
	void appendMenu (DVDMenu *, QString, QString);
	void appendPostProcessing ();
	bool readIniFile ();
	bool saveIniFile ();
	void setDefault (int, uint);
	QDVDAuthorInit::MenuBlock::Block *getBlock (int);
	QString resolvString  (QString);
	void setKeywords (QValueList<QString>);

private:	// private functions.
	bool    initMe ();
	void    addBlock(ExecuteInterface *, MenuBlock::Block *);
	bool    readBlock (MenuBlock::Block *, QDomElement *);
	bool    readMenuBlock (MenuBlock *, QDomElement *);
	bool    saveMenuBlock (MenuBlock *, QDomElement *);
	bool    saveBlock (MenuBlock::Block *, QDomElement *);
	QString convertSoundFile (QString);
	void    resetInitFile ();

private:	// private variables
	int                  m_iCurrentBlockID;
	QString              m_qsTempPath;
	QString              m_qsProjectPath;
	QString              m_qsDvdauthor;
	QStringList          m_listKeywords;
	QValueList<QColor *> m_arrayColors;
	int                  m_iColorCounter;
	MenuBlock            m_palMenuBlock;
	MenuBlock            m_ntscMenuBlock;
	MenuBlock            m_dvdauthorMenuBlock;
	MenuBlock            m_burningMenuBlock;
	QStringList          m_soundList;

	// Pre processing steps
	// ... nothing thus far ...

	// Post processing steps
	ExecuteInterface m_dvdauthorInterface;
	ExecuteInterface m_burnInterface;

	// THe full list of commands to execute ...
	QValueList <ExecuteInterface *>m_listExecute;
	friend class DialogCommandEditor;
	friend class DialogExecute;
};

#endif // QDVDAUTHORINIT_H

/* File structure :
XML
-- Definition :
	+WIDTH+                = Background Width
	+HEIGHT+               = Background Height
	+FORMAT+               = "PAL" or "NTSC"
	+MENU_NAME+            = E.g. Main Menu VMGM
	+BACKGROUND_FILE_NAME+ = E.g. Main Menu VMGMbackground.jpg
	+TEMP_PATH+            = E.g. /tmp
	+SOUND_LIST+           = All sound files in mp2 format (including \" - characters !)
	                         E.g. \"sound1.mp2\" \"sound2.mp2\"
	+DVDAUTHOR_XML+        = E.g. /tmp/dvdauthor.xml
	+PROJECT_PATH+         = Where the DVD filestructure will be created (E.g. /tmp/myDVD/dvd)

		arrayColors[0] = QColor (158,238,129); //
	arrayColors[1] = QColor (143,238,211); //
	arrayColors[2] = QColor (224,238,143); // #E0EE8F
	arrayColors[3] = QColor (237,151,238); // #ED97EE
	arrayColors[4] = QColor (158,238,129); // #9EEE81
	arrayColors[5] = QColor (143,238,211); // #8FEED3
	arrayColors[6] = QColor (224,238,143); // #E0EE8F
	arrayColors[7] = QColor (237,151,238); // #ED97EE
	arrayColors[8] = QColor (158,238,129); // #9EEE81
	arrayColors[9] = QColor (143,238,211); // #8FEED3
	arrayColors[10]= QColor (224,238,143); // #E0EE8F
	arrayColors[11]= QColor (249,47,94);   // #F92F5E

Following is the default init file ...
<QDVDAuthorInitFile>
  <Color number="0">#9EEE81</Color>
  <Color number="1">#8FEED3</Color>
  <Color number="2">#E0EE8F</Color>
  <Color number="3">#ED97EE</Color>
  <Color number="4">#9EEE81</Color>
  <Color number="5">#8FEED3</Color>
  <Color number="6">#E0EE8F</Color>
  <Color number="7">#ED97EE</Color>
  <Color number="8">#9EEE81</Color>
  <Color number="9">#8FEED3</Color>
  <Color number="10">#E0EE8F</Color>
  <Color number="11">#F92F5E</Color>
  <ExecuteInterface>
    <Pal blockname="+MENU_NAME+ (PAL +WIDTH+x+HEIGHT+)" color="#9EEE81">
      <Block name="MOVIE_BACKGROUND">
        <Comment><p align=\"center\">This line of command will convert the background movie<BR>into a MPEG2 stream in PAL format +WIDTH+x+HEIGHT+</p></Comment>
        <Command default="true">transcode -i -V -J fps 25 --export_asr 2 --keep_asr -Z +WIDTH+x+HEIGHT+ -y jpg,wav -m +TEMP_PATH+/audio+MENU_NAME+.wav -o background+MENU_NAME+</Command>
      </Block>
      <Block name="IMAGE_BACKGROUND">
        <Comment><p align=\"center\">This line of command will convert the background image<BR>into a MPEG2 stream in PAL format +WIDTH+x+HEIGHT+</p></Comment>
        <Command>jpegtopnm \"+BACKGROUND_FILE_NAME+\" | ppmtoy4m -n 1 -F25:1 -A59:54 -I t -L | mpeg2enc -f 8 -n p -o \"+MENU_NAME+.m2v\"<Command>
        <Command default="true">jpeg2yuv -n 50 -I p -f 25 -j \"+BACKGROUND_FILE_NAME+\" | mpeg2enc -n p -f 8 -o \"+MENU_NAME+.m2v\"</Command>
      </Block>
      <Block name="EMPTY_SOUND">
        <Comment><p align=\"center\">This line creates an empty sound file to mix into the menu-movie.</P></Comment>
        <Command>arecord -f dat -twav -d 1 /dev/stdout | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>sox -t raw -s -w -c 2 -r 48000 /dev/zero -t wav -c 2 -r 48000 /dev/stdout trim 0 1 | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command default="true">dd if=/dev/zero bs=4 count=1920 | toolame -b128 -s 48 /dev/stdin \"+MENU_NAME+.mp2\"</Command>
      </Block>
      <Block name="MPLEX">
        <Comment><p align=\"center\">The following command will multiplex the sound file into the menu-movie.</p></Comment>
        <Command default="true">mplex -f 8 -o \"+MENU_NAME+.mpg\" \"+MENU_NAME+.m2v\" +SOUND_LIST+</Command>
      </Block>
      <Block name="SPUMUX">
        <Comment><p align=\"center\">Here we use spumux to add the subpicture (buttons) the the mpeg2 video.</p></Comment>
        <Command default="true">spumux \"+MENU_NAME+.xml\" < \"+MENU_NAME+.mpg\" > \"+MENU_NAME+_menu.mpg\"</Command>
      </Block>
    </Pal>
    <Ntsc blockname=" (NTSC +WIDTH+x+HEIGHT+)" backgroundcolor="1">
      <Block name="MOVIE_BACKGROUND">
        <Comment><p align=\"center\">This line of command will convert the background movie<BR>into a MPEG2 stream in NTSC format +WIDTH+x+HEIGHT+</p></Comment>
        <Command default="true">transcode -i -V -J fps 29.970 --export_asr 2 --keep_asr -Z +WIDTH+x+HEIGHT+ -y jpg,wav -m +TEMP_PATH+/audio+MENU_NAME+.wav -o background+MENU_NAME+</Command>
      </Block>      
      <Block name="IMAGE_BACKGROUND">
        <Comment><p align=\"center\">This line of command will convert the background image<BR>into a MPEG2 stream in NTSC format +WIDTH+x+HEIGHT+</p></Comment>
        <Command>jpegtopnm \"+BACKGROUND_FILE_NAME+\" | ppmtoy4m -n 1 -F30000:1001 -A10:11 -I t -L | mpeg2enc -f 8 -n n -o \"+MENU_NAME.m2v\"</Command>
        <Command default="true">jpeg2yuv -n 50 -I p -f 29.97 -j \"+BACKGROUND_FILE_NAME+\" | mpeg2enc -n n -f 8 -o \"+MENU_NAME+.m2v\"</Command>
      </Block>
      <Block name=EMPTY_SOUND">
        <Comment><p align=\"center\">This line creates an empty sound file to mix into the menu-movie.</P></Comment>
        <Command default="true">arecord -f dat -twav -d 1 /dev/stdout | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>sox -t raw -s -w -c 2 -r 48000 /dev/zero -t wav -c 2 -r 48000 /dev/stdout trim 0 1 | mp2enc -r 48000 -o \"+MENU_NAME+.mp2\"</Command>
        <Command>dd if=/dev/zero bs=4 count=1601.6 | toolame -b128 -s 48 /dev/stdin \"+MENU_NAME+.mp2\"</Command>
      </Block>
      <Block name="MPLEX">
        <Comment><p align=\"center\">The following command will multiplex the sound file into the menu-movie.</p></Comment>
        <Comman default="true"d>mplex -f 8 -o \"+MENU_NAME+.mpg\" \"+MENU_NAME+.m2v\" +SOUND_LIST+</Command>
      </Block>
      <Block name="SPUMUX">
        <Comment><p align=\"center\">Here we use spumux to add the subpicture (buttons) the the mpeg2 video.</p></Comment>
        <Command default="true">spumux \"+MENU_NAME+.xml\" < \"+MENU_NAME+.mpg\" > \"+MENU_NAME+_menu.mpg\"</Command>
      </Block>
    </Ntsc>
  </ExecuteInterface>
  <ExecuteInterface>
    <Dvdauthor blockname="dvdauthor" color="#F92F5E">
      <Block>
        <Comment>Here we start dvdauthor with the generated xml file.</Comment>
        <Command>dvdauthor -x \"+DVDAUTHOR_XML+\"</Command>
      </Block>
    </Dvdauthor>
  </ExecuteInterface>
  <ExecuteInterface hidden="true">
    <Burning blockname="Burn DVD">
      <Block>
        <Comment>Last we burn the DVD.</Comment>
        <Command>growisofs -Z /dev/dvd -dvd-video +PROJECT_PATH+/</Command>
        <Comment>This command will format a empty -RW DVD (only needed for older drives).</Comment>
        <Command>dvd+rw-format -f /dev/srcd0</Command>
        <Comment>This command generates an iso image of the DVD.</Comment>
        <Command>mkisofs -dvd-video -udf -o +TEMP_PATH+/dvd.iso +PROJECT_PATH+/</Command>
        <Comment>This command burns the iso DVD image to DVD</Comment>
        <Command>dvdrecord -dao speed=2 dev=0,0,0 +TEMP_PATH+/dvd.iso</Command>
      </Block>
    </Burning>
  </ExecuteInterface>
</QDVDAuthorInitFile>
*/

