/****************************************************************************
** SourceFileEntry - class
**
** Created: Thu Jun 10 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will use the xineEngine to obtain information about the 
** stream currently set by this engine.
**
****************************************************************************/

#ifndef XINEINFO_H
#define XINEINFO_H

#include <qthread.h>
#include <qstring.h>

#include <xine.h>


class CreateXineEngine : protected QThread
{
public:
	 CreateXineEngine (xine_t **, QString);
	~CreateXineEngine ();

protected:
	void run ();
	xine_t **m_ppXineEngine;
	QString  m_qsConfigFile;
};

class XineInfo
{
public:
	 XineInfo ();
	~XineInfo ();

	XineInfo (xine_t *);
	XineInfo (xine_stream_t *);
	xine_t *getXine ();
	xine_stream_t *getXineStream ();
	void setXineStream (xine_stream_t *);
	void setStream (QString);

	QString getFileName (bool b=true);
	unsigned long int getLength ();
	QString getLengthString ();
	QString getRatio        ();
	QString getFormat       (bool);
	QString getCodec        (bool);
	uint    getSize         ();
	QString getSizeString   ();
	int     getResolution   (bool);
	QString getResolutionString ();
	float   getFPS          ();
	QString getStatus       ();
	int     getSample       ();
	QString getSampleString ();
	int     getBPS          (bool);
	QString getBPSString    (bool);
	int     getBits         ();

	bool hasAudio ();
	bool hasVideo ();
	
	bool audioHandled ();
	bool videoHandled ();

	
	QImage getScreenshot(QString);
	void GetScreenshot(uchar*&, int&, int&, double&) const;

private:
	void initMe ();
	void queryValues ();
	QString msToTimeString(unsigned long int);
	char * get_fourcc_string (int);
	QString getVideoFormat (int, int);
	void createXineStream ();

private:
	xine_t        *m_pXine;
	xine_stream_t *m_pXineStream;
	xine_audio_port_t *m_pAudioDriver;
	xine_video_port_t *m_pVideoDriver;
	bool           m_bOwnXineEngine;
	bool           m_bOwnXineStream;
	bool           m_bHaveValues;


	bool    m_bHasAudio;
	bool    m_bHasVideo;
	bool    m_bAudioHandled;
	bool    m_bVideoHandled;
	QString m_qsAudioCodec;
	QString m_qsVideoCodec;
	QString m_qsFileName;	// E.g. video.mpg
	uint    m_iSize;
	QString m_qsSize;	// E.g. 2.2M
	int     m_iResolutionWidth;
	int     m_iResolutionHeight;
	QString m_qsResolution;	// E.g. 720x576
	float   m_fFPS;
	QString m_qsFPS;		// E.g. 25
	QString m_qsRatio;	// E.g. 16:9
	unsigned long int m_iLength;
	QString m_qsLength;	// E.g. 01:22:23
	QString m_qsVideoFormat;	// E.g. 'PAL'
	QString m_qsAudioFormat;	// E.g. 'Stereo'
	QString m_qsStatus;	// E.g. Ok	-=> to say this file we can autmatically convert to a DVD video
	// For Audio Sources :
	int     m_iBits;
	int     m_iSample;
	QString m_qsSample;	// E.g. 48kHz
	int     m_iAudioBPS;	// E.g. 224000
	QString m_qsAudioBPS;	// E.g. 224kbps
	int     m_iVideoBPS;	// E.g. 978000
	QString m_qsVideoBPS;	// E.g. p78kbps
};


#endif	// XINEINFO_H

