/****************************************************************************
** SourceFileEntry - class
**
** Created: Tue Mar 22 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class is a simple container class to store the info
** for a entry in the Source File List.
**
****************************************************************************/

#include <qmessagebox.h>
#include <qdom.h>

#include "xml_dvd.h"
#include "sourcefileentry.h"

SourceFileEntry::SourceFileEntry ()
{
	bIsSlideshow = false;
	iTitleset = 0;
	iTitle    = 0;
	bSoundSource = false;
}

SourceFileEntry::~SourceFileEntry()
{
	uint t;
	for (t=0;t<listFileInfos.count();t++)	
		delete listFileInfos[t];
}

bool SourceFileEntry::readProjectFile  (QDomNode &xmlNode)
{
	QString qsAttribute, infoName, infoText;

	QDomNode    infoNode;
	QDomElement infoElement;
	QDomElement theElement = xmlNode.toElement();

	QDomAttr a = theElement.attributeNode ( SOURCE_OBJECT_DISPLAY_NAME );
	qsDisplayName = a.value();
	qsAttribute = theElement.attributeNode ( SOURCE_OBJECT_IS_SOUND_SOURCE ).value();
	bSoundSource = false;
	if ( (!qsAttribute.isEmpty ()) && (qsAttribute == QString ("true")) )
			bSoundSource = true;

	QDomNode sourceNode = theElement.firstChild();
	while (!sourceNode.isNull() )	{
		theElement = sourceNode.toElement();
		// Okay, here we read the stored data from the xml file.
		QString tagName = theElement.tagName();
		// Okay, this is ugly but after all it is the simplest of all xml file structure.
		// No need to get fancy ...
		if (SOURCE_OBJECT_INFO == tagName)	{
			SourceFileInfo *pFileInfos = new SourceFileInfo;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_SIZE).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsSize = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_RESOLUTION).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsResolution = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_FPS).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsFPS = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_RATIO).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsRatio = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_LENGTH).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsLength = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_FORMAT).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsFormat = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_STATUS).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsStatus = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_BITS).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsBits = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_SAMPLE).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsSample = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_BPS).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsBPS = qsAttribute;

			infoNode = theElement.firstChild ();
			while (!infoNode.isNull())	{
				infoElement = infoNode.toElement();
				// Okay, here we read the stored data from the xml file.
				infoName = infoElement.tagName();
				infoText = infoElement.text ();
				if (SOURCE_OBJECT_FILE_NAME == infoName)	{
					if (!infoText.isEmpty())
						pFileInfos->qsFileName = infoText;
				}
				if (SOURCE_OBJECT_CHAPTERS == infoName)	{
					if (!infoText.isEmpty())
						pFileInfos->listChapters = QStringList::split (",", infoText);
				}
				infoNode = infoNode.nextSibling ();
			}
			listFileInfos.append (pFileInfos);
		}
		else if (SOURCE_OBJECT_CHAPTERS == tagName)
			infoText = theElement.text ();
			listChapters = QStringList::split ( QString (","), infoText);
		// Otherwise go to the next node ...
		sourceNode = sourceNode.nextSibling();
	}
	return true;
}

bool SourceFileEntry::writeProjectFile (QDomElement &theElement)
{
	// This check means that the slideshow has not yet been finished, thus we should not bother to
	// store this record since the mpeg does probably not exist.
	if (bIsSlideshow)	{
		QMessageBox::warning (NULL,QObject::tr("Warning"), QObject::tr ("Warning, the slideshow \n%1\nis not finished.\nThe SourceFileEntry will not be stored.").arg(qsDisplayName), QMessageBox::Ok, QMessageBox::Ok);
		return true;
	}
	uint t;
	QDomDocument xmlDoc = theElement.ownerDocument();
	QDomElement sourceNode = xmlDoc.createElement( SOURCE_OBJECT );	// <FrameObject>

	QDomElement fileElement, infoElement, chapterElement; //tag;
	QDomElement tag;
	QDomText text;
	// Here we set the attributes of the <dvdauthor> tag
	if (!qsDisplayName.isNull())
		sourceNode.setAttribute( SOURCE_OBJECT_DISPLAY_NAME, qsDisplayName );
	if (bSoundSource)
		sourceNode.setAttribute( SOURCE_OBJECT_IS_SOUND_SOURCE, "true" );

	if (listFileInfos.count() > 0)	{
		for (t=0;t<listFileInfos.count();t++)	{
			infoElement = xmlDoc.createElement( SOURCE_OBJECT_INFO );
			if (!listFileInfos[t]->qsSize.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_SIZE, listFileInfos[t]->qsSize );
			if (!listFileInfos[t]->qsResolution.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_RESOLUTION, listFileInfos[t]->qsResolution );
			if (!listFileInfos[t]->qsFPS.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_FPS, listFileInfos[t]->qsFPS );
			if (!listFileInfos[t]->qsRatio.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_RATIO, listFileInfos[t]->qsRatio );
			if (!listFileInfos[t]->qsLength.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_LENGTH, listFileInfos[t]->qsLength );
			if (!listFileInfos[t]->qsFormat.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_FORMAT, listFileInfos[t]->qsFormat );
			if (!listFileInfos[t]->qsStatus.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_STATUS, listFileInfos[t]->qsStatus );
			if (!listFileInfos[t]->qsBits.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_BITS, listFileInfos[t]->qsBits );
			if (!listFileInfos[t]->qsSample.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_SAMPLE, listFileInfos[t]->qsSample );
			if (!listFileInfos[t]->qsBPS.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_BPS, listFileInfos[t]->qsBPS );
			// Here we create another level in the XML tree for name and chapter ...
				fileElement = xmlDoc.createElement( SOURCE_OBJECT_FILE_NAME );
				text = xmlDoc.createTextNode(listFileInfos[t]->qsFileName);
				fileElement.appendChild( text );
				infoElement.appendChild( fileElement );

				if (listFileInfos[t]->listChapters.count() > 0)	{
					chapterElement = xmlDoc.createElement( SOURCE_OBJECT_CHAPTERS );
					text = xmlDoc.createTextNode(listFileInfos[t]->listChapters.join(QString(",")));
					chapterElement.appendChild( text );
					infoElement.appendChild( chapterElement );
				}
			sourceNode.appendChild( infoElement );
		}
	}
	if (listChapters.count() > 0)	{
		chapterElement = xmlDoc.createElement( SOURCE_OBJECT_CHAPTERS );
		sourceNode.appendChild( chapterElement );
		text = xmlDoc.createTextNode(listChapters.join(QString(",")));
		chapterElement.appendChild( text );
	}

	theElement.appendChild( sourceNode );
	return true;
}

SourceFileEntry & SourceFileEntry::operator = (SourceFileEntry &theOther)
{
	uint t;
	SourceFileInfo *pInfo;
	// First we take care of the entries in the list. Please note that we should keep the current ones around
	// in case we are cloning this entry.
	QValueList<SourceFileInfo *> listTemp2;
	for (t=0;t<theOther.listFileInfos.count();t++)	{
		pInfo = new SourceFileInfo ();
		*pInfo = *theOther.listFileInfos[t];
		listTemp2.append (pInfo);
	}
	// Now we should be save here to remove the entries ...	
	for (t=0;t<listFileInfos.count ();t++)
		delete listFileInfos[t];
	listFileInfos.clear();

	listFileInfos = listTemp2;

	qsDisplayName = theOther.qsDisplayName;
	listChapters  = theOther.listChapters;
	bSoundSource  = theOther.bSoundSource;
	bIsSlideshow  = theOther.bIsSlideshow;
	iTitleset     = theOther.iTitleset;
	iTitle        = theOther.iTitle;

	return *this;
}



SourceFileInfo & SourceFileInfo::operator = (SourceFileInfo &theOther)
{
	qsFileName   = theOther.qsFileName;
	qsSize       = theOther.qsSize;
	qsResolution = theOther.qsResolution;
	qsFPS        = theOther.qsFPS;
	qsRatio      = theOther.qsRatio;
	qsLength     = theOther.qsLength;
	qsFormat     = theOther.qsFormat;
	qsStatus     = theOther.qsStatus;
	qsBits       = theOther.qsBits;
	qsSample     = theOther.qsSample;
	qsBPS        = theOther.qsBPS;
	listChapters = theOther.listChapters;
	return *this;
}

int SourceFileInfo::getMsFromString(QString qsInput)
{
	uint iHours, iMinutes, iSeconds, iMilliSeconds, iStepper;
	float fSeconds=0.0;
	iStepper=0;
	// 00:00:00.000
	iHours = iMinutes = iSeconds = iMilliSeconds = 0;
	QStringList listParts = QStringList::split (":", qsInput);
	if (listParts.count() > 3)
		return 0;
	if (listParts.count() > 2)
		iHours = listParts[iStepper++].toInt();
	if (listParts.count() > 1)
		iMinutes = listParts[iStepper++].toInt();
	if (listParts.count() > 0)
		fSeconds = listParts[iStepper++].toFloat();
	iMilliSeconds = (uint)(1000*fSeconds) + 60*1000*iMinutes + 60*60*1000*iHours;
	return iMilliSeconds;
}

QString SourceFileInfo::getStringFromMs(int iInput)
{
	uint iHours, iMinutes, iSeconds;
	double fMilliSeconds=0.0;
	iHours = iMinutes = iSeconds = 0;
	QString qsReturn ("00:00:00.000");
	fMilliSeconds = (double)iInput;
	if (fMilliSeconds >= 3600000.0)	// 60*60*1000
		iHours = (int)(fMilliSeconds/3600000.0);
	fMilliSeconds -= iHours * 3600000;
	if (fMilliSeconds >= 60000.0)	// 60*1000
		iMinutes = (int)(fMilliSeconds/60000.0);
	if (iMinutes > 60)
		iMinutes = 0;
	fMilliSeconds -= iMinutes * 60000;
	if (fMilliSeconds >= 1000.0)
		iSeconds = (int)(fMilliSeconds/1000.0);
	if (iSeconds > 60)
		iSeconds = 0;
	fMilliSeconds -= iSeconds * 1000;
	if (fMilliSeconds > 1000)
		fMilliSeconds = 0;

	qsReturn.sprintf ("%02d:%02d:%02d.%03d", iHours, iMinutes, iSeconds, (int)fMilliSeconds);
	return qsReturn;
}



