/****************************************************************************
** Interface to the GUI.
**
** Created: Tue 04 May 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will create a toolbar, which displays all currently selected
** sources for the DVD, such as all Videos, and all Audio files.
**
** Besides displaying these it will also do some background checks.
** For this it will spawn a new thread, which will analyse the file
** and see if it needs to get converted for a propper usage.
**
** tcscan is your friend.
** 
** The result will be color coded.
** o	Gray, not yet determined
** o	any shades of green -> In DVD format.
** o	any shades of blue  -> will be converted before creating DVD
** o	any shades of red   -> Can not automatically handle this format.
**
****************************************************************************/

#ifndef SOURCETOOLBAR_H
#define SOURCETOOLBAR_H

#include <qtoolbar.h>

// The following two defines specify which column the file name is to be found. 
#define MOVIE_FILE_NAME_INDEX 7
#define AUDIO_FILE_NAME_INDEX 7

#include "uisourcewidget.h"
#include "sourcefileentry.h"

class QDVDAuthor;

class SourceToolBar : public QToolBar
{
	Q_OBJECT

public:
	 SourceToolBar (const QString &, QMainWindow *, QWidget *, bool b=FALSE, const char *n=0, WFlags f=0);
	~SourceToolBar ();

//	void addMovie (QString &);
	void addMovie (SourceFileEntry *);
	void addSound (QStringList &);
	void clear ();
	
	int sourceFileCount();
	SourceFileEntry *sourceFileEntry(uint);
	SourceFileEntry *getCurrentSourceFileEntry();
	void appendSourceFileEntry(SourceFileEntry *);
	void removeEntry (QString &, bool b=true);

	virtual QSize sizeHint () const;
	QString convertFileSize(uint);

private:
	void refreshToolBarEntries ();
	int getFreeSourceSlot ();

public slots:
	virtual void slotClickedOnVideoList(int, QListBoxItem *, const QPoint &);
	virtual void slotEditMovie();
	virtual void slotConvertMovie();
	virtual void slotDeleteSource();
	virtual void slotPlayMovie();

	virtual void slotAddMovie ();
	virtual void slotAddSound ();
	virtual void slotAddSlideshow ();
	virtual void slotAddSlideshow (QString);
	virtual void slotSlideshowDone(QString);

private:
	uiSourceWidget *m_pSourceWidget;
	QDVDAuthor     *m_pDVDAuthor;
	QValueList<SourceFileEntry *>	m_listSourceFileEntries;
};

#endif // SOURCETOOLBAR_H


