%define dvd_slideshow dvd-slideshow_0.7.1
%define _prefix /usr

# determine what platform we are building on
%define fedora 0
%define suse 0
%define mdk 0

%if %{_vendor} == redhat
	%define fedora 1
	%define _dist %(cat /etc/redhat-release)
%endif
%if %{_vendor} == suse
	%define suse 1
	%define _dist %(grep SuSE /etc/SuSE-release)
%endif
%if %{_vendor} == mandrake
	%define mdk 1
	%define _dist %(grep Mandrake /etc/mandrake-release)
%endif

%if ! %{fedora} && ! %{suse} && ! %{mdk}
%{error: Unknown platform. Please examine the spec file.}
exit 1
%endif

# manual define for 64 bit
%define amd64 0
%{?build_amd64:%define amd64 1}

# media backend selection - default to mplayer
%define xine_support 0
%define mplayer_support 0
%define vlc_support 0
%{?build_xine:%define xine_support 1}
%{?build_mplayer:%define mplayer_support 1}
%{?build_vlc:%define vlc_support 1}
%if ! %{xine_support} && ! %{mplayer_support}
	%define mplayer_support 1
%endif
%if %{xine_support}
	%define configure_opts --with-xine-support
	%define media_backend Xine
%endif
%if %{mplayer_support}
	%define configure_opts --with-mplayer-support
	%define media_backend MPlayer
%endif
%if %{vlc_support}
	%define configure_opts --with-vlc-support
	%define media_backend VLC
%endif

Summary: QDVDAuthor, the GUI frontend for dvdauthor and other related tools.
Name: qdvdauthor
Version: 0.1.0
Release: 1
Group: Applications/Multimedia
Copyright: GPL v2
Distribution: %{_dist}
Source0: %{name}-%{version}.tar.gz
Source1: %{dvd_slideshow}.tar.gz
#Patch0: %{name}-%{version}.patch
BuildRoot: %{_tmppath}/%{name}-root
URL: http://qdvdauthor.sourceforge.net/
Packager: D. Scott Barninger <barninger at fairfieldcomputers dot com>
%define qdvdauthor_dir %{name}-%{version}

%if %{fedora} && %{xine_support}
BuildRequires: xine-lib-devel
%endif
%if %{suse} && %{xine_support}
BuildRequires: libxine1-devel
%endif
%if %{mdk} && %{xine_support}
BuildRequires: libxine1-devel
%endif
%if %{fedora}
BuildRequires: bzip2-devel
%endif
%if %{suse}
BuildRequires: bzip2
%endif
%if %{mdk}
BuildRequires: libbzip2-devel
%endif
%if %{fedora}
BuildRequires: qt-devel
%endif
%if %{suse}
BuildRequires: qt3-devel
%endif
%if %{mdk}
BuildRequires: libqt3-devel
%endif
BuildRequires: glibc-devel
%if %{fedora}
BuildRequires: freetype-devel
%endif
%if %{suse} || %{mdk}
BuildRequires: freetype2-devel
%endif
%if %{fedora} || %{mdk}
BuildRequires: libjpeg-devel
%endif
%if %{suse}
BuildRequires: libjpeg
%endif
BuildRequires: libpng-devel
%if %{fedora} || %{mdk}
BuildRequires: libtiff-devel
%endif
%if %{suse}
BuildRequires: libtiff
%endif
BuildRequires: libxml2-devel >= 2.6
BuildRequires: zlib-devel

Requires: bzip2
Requires: dvdauthor >= 0.6.10
Requires: mjpegtools
%if %{fedora}
Requires: qt
%endif
%if %{suse}
Requires: qt3
%endif
%if %{mdk}
Requires: libqt3
%endif
Requires: glibc
Requires: libgcc
%if %{fedora}
Requires: freetype
%endif
%if %{suse} || %{mdk}
Requires: freetype2
%endif
Requires: libjpeg
Requires: libpng
Requires: libtiff
Requires: libxml2 >= 2.6
Requires: zlib
Requires: sox
%if %{mdk} && %{xine_support}
Requires: libxine1
%endif
%if %{suse} && %{xine_support}
Requires: libxine1
%endif
%if %{fedora} && %{xine_support}
Requires: xine-lib
%endif
%if %{mdk} && %{mplayer_support}
Requires: mplayer
%endif
%if %{suse} && %{mplayer_support}
Requires: MPlayer
%endif
%if %{fedora} && %{mplayer_support}
Requires: mplayer
%endif
%if %{mdk} && %{vlc_support}
Requires: vlc
%endif
%if %{suse} && %{vlc_support}
Requires: vlc
%endif
%if %{fedora} && %{vlc_support}
Requires: vlc
%endif
%if %{suse} || %{mdk}
Requires: netpbm
%endif
%if %{fedora}
Requires: netpbm-progs
%endif

Conflicts: dvd-slideshow

%description

QDVDAuthor is a gui frontend for using dvdauthor and dvd-slideshow 
scripts to easily build DVD menus and assemble the DVD VOB files. 
This package includes %{dvd_slideshow} in the installation and 
requires %{media_backend}.

%prep

%setup -b 1
#%patch -p1

%build

%if %{amd64} && %{suse}
# This is the usual path and environment for AMD64 with SuSE 9.0 
export LDFLAGS=-L/usr/X11/lib64 
export QMAKESPEC=linux-g++-64
%endif

./configure --prefix=%{_prefix} --build-qplayer --build-qslideshow %{configure_opts}

# No call to make is necessary because it is done by the configure script

%install

[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"

mkdir -p $RPM_BUILD_ROOT%{_prefix}/bin
mkdir -p $RPM_BUILD_ROOT%{_prefix}/man/man1
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/pixmaps
mkdir -p $RPM_BUILD_ROOT%{_prefix}/share/applications
install -m 0755 $RPM_BUILD_DIR/%{qdvdauthor_dir}/bin/qdvdauthor \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{qdvdauthor_dir}/bin/qslideshow \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{qdvdauthor_dir}/bin/qplayer \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/dvd-slideshow \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/dvd-menu \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/gallery2slideshow \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/jigl2slideshow \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0755 $RPM_BUILD_DIR/%{dvd_slideshow}/dir2slideshow \
	$RPM_BUILD_ROOT%{_prefix}/bin
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/dvd-slideshow.1 \
	$RPM_BUILD_ROOT%{_prefix}/man/man1
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/dvd-menu.1 \
	$RPM_BUILD_ROOT%{_prefix}/man/man1
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/dir2slideshow.1 \
	$RPM_BUILD_ROOT%{_prefix}/man/man1
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/gallery2slideshow.1 \
	$RPM_BUILD_ROOT%{_prefix}/man/man1
install -m 0644 $RPM_BUILD_DIR/%{dvd_slideshow}/man/jigl2slideshow.1 \
	$RPM_BUILD_ROOT%{_prefix}/man/man1
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor.png \
	$RPM_BUILD_ROOT%{_prefix}/share/pixmaps
install -m 0644 $RPM_BUILD_DIR/%{qdvdauthor_dir}/qdvdauthor.desktop \
	$RPM_BUILD_ROOT%{_prefix}/share/applications


%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"

%files
%defattr(-,root,root)
%{_prefix}/bin/qdvdauthor
%{_prefix}/bin/qslideshow
%{_prefix}/bin/qplayer
%{_prefix}/bin/dvd-slideshow
%{_prefix}/bin/dvd-menu
%{_prefix}/bin/gallery2slideshow
%{_prefix}/bin/jigl2slideshow
%{_prefix}/bin/dir2slideshow
%{_prefix}/man/man1/*
%{_prefix}/share/pixmaps/qdvdauthor.png
%{_prefix}/share/applications/qdvdauthor.desktop
%doc README TODO COPYING CHANGELOG

%post

%preun

%changelog
* Tue Sep 06 2005 V. Okan <QDVDAuthor at users.sf.net>
- added vlc support. Made small modifications to dvd-slideshow.0.7.1
* Sun Feb 13 2005 D. Scott Barninger <barninger at fairfieldcomputers.com>
- fix redhat detection
* Sun Feb 06 2005 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.0.9 release
- add command line switch for media backend
* Sat Feb 05 2005 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.0.9 release
- add platform detection
- add xine/mplayer build options
* Mon Jan 24 2005 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.0.9 release
- remove manual configuration and go with configure script
- add _prefix variable
* Sun Nov 07 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- 0.0.8 release
- remove ImageMagick Build dependancy
- add Mandrake build support
- updated dvd-slideshow to 0.6.0
- dvd-slideshow now has rpms on sourceforge so add a Conflict
- remove rh9 build and replace with fedora (for all RedHat builds)
- add qplayer application
* Sun May 16 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- update requires for 0.0.6 (xine)
- add build define for AMD 64 bit support
* Sat Apr 03 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- now require dvdauthor >= 0.6.10 and libxml2 >= 2.6
* Tue Mar 09 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- updated dvd-slideshow to 0.5.4
- add dir2slideshow script & man page
- add gallery2slideshow man page
- add jigl2slideshow man page
- added sox to prerequisites (required by dvd-slideshow)
- removed redundant permissions attributes in files section (also bad form per Michael K. Johnson)
- added additional clean of build_root to top of install section
- removed clean of build_dir
* Tue Feb 17 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- changed qt requirement to 3.1
- fixed location of description section; dependencies weren't working
* Sun Feb 15 2004 D. Scott Barninger <barninger at fairfieldcomputers.com>
- initial spec file
