/****************************************************************************
** Interface to the GUI.
**
** Created: Wed Jan 26 22:48:00 2005
**      by: Varol Okan using kate editor
**
**
****************************************************************************/

#ifndef DIALOGMOVIEOBJECT_H
#define DIALOGMOVIEOBJECT_H

#include <qrect.h>

#include "uidialogmovieobject.h"

class MovieObject;
class DVDMenu;
class MediaInterface;
class StartStopControl;

class DialogMovieObject : public uiDialogMovieObject
{
	Q_OBJECT
public:
	 DialogMovieObject(QWidget *p=NULL, const char *n=NULL, WFlags f=0);
	~DialogMovieObject();

	void initMe(MovieObject *);
	void initMe(DVDMenu     *);

protected slots:
	virtual void slotWidth ();
	virtual void slotHeight();
	virtual void slotPlay  ();
	virtual void slotStop  ();
	virtual void slotStart ();
	virtual void slotEnd   ();

	virtual void slotNewPosition(int, const QString&);
	virtual void slotSliderValues (float, float);

private:
	void setStartStop (bool);

private:
	QRect m_rectGeometry;
	QString m_qsFileName;
	QString m_qsPosition;
	int     m_iMovieLength;
	MediaInterface   *m_pMediaInterface;
	StartStopControl *m_pStartStopControl;
};

#endif // DIALOGMOVIEOBJECT_H
