/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Dec 14 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef MENU_H
#define MENU_H

#include <qobject.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qtoolbar.h>
#include <qpopupmenu.h>
#include <qaction.h>
#include <qimage.h>
#include <qdom.h>

#include "global.h"
#include "qdvdauthor.h"
#include "xml_dvdauthor.h"

#define VMGM_LABEL "Main Menu VMGM"

class QTimer;

class MenuPreview;
class MenuObject;
class ButtonObject;
class MovieObject;
class SubMenus;
class DVDInfo;
class UndoBuffer;
class DialogUndoStack;
class uiDialogRenderPreview;
class SourceFileEntry;
class SourceFileInfo;


// Container class to encapsulate all variables for the DVDMenu - class
class CDVDMenuInterface
{
public:
	 CDVDMenuInterface ();
	~CDVDMenuInterface ();
	void initMe ();

	enum { StretchToFit = 0, StretchBlackBorders, StretchCutOff };

	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);

	// variables.
	bool bModified;
	bool bIsSubMenu;
	QString qsMenuName;
	QStringList listSoundEntries;

	// the following entries belong to the movie background
	QString qsMovieFileName;
	bool    bMovieBackgroundHasSound;
	QTime   timeOffset;
	QTime   timeDuration;
	// The following var is the background image or screenshot of the Movie ...
	QString qsBackgroundFileName;

	QString qsSelectedMaskFileName;
	QString qsHighlightedMaskFileName;
	QString qsResizeAlgo;
	QString qsAnimation;
	int     iStretchType;	// StretchToFit, BlackBorders, CutOffset
	QSize   posOffset;
	int     iFormat;
	int     iWidth;
	int     iHeight;
	int     iTitleset;
	int     iMenu;
	QString qsRatio;

	// generated by importdvdauthor.cpp::buildMenuFromPgc()
	QValueList <CXmlDVDAuthor::vob_struct *>listIntroVobs;
	QValueList <CXmlDVDAuthor::vob_struct *>listExtroVobs;
	QString qsPre;
	QString qsPause;
	QString qsPost;

	QPixmap backgroundImage;
	QPixmap highlightedMask;
	QPixmap selectedMask;
	QColor  pgcColors[MAX_MASK_COLORS];
};

class DVDMenu : public QObject
{
	Q_OBJECT
protected:
	 DVDMenu ();
public:
	// Constructor / destructor
	 DVDMenu (QDVDAuthor *pDVDAuthor);
	~DVDMenu ();

public slots:
	virtual void slotAddBackground      ();
	virtual void slotAddSound           ();
	virtual void slotShowHighlightedMask();
	virtual void slotShowSelectedMask   ();
	virtual void slotAddHighlightedMask ();
	virtual void slotAddSelectedMask    ();
	virtual void slotStructureClicked   (QListViewItem *);
	virtual void slotDroppedSomething   (uint);
	virtual void slotCreatedMovieObject (MovieObject *, bool);
	virtual void slotUpdateStructure    ();
	virtual void slotRequestSourceFiles ();
	virtual void slotRequestSubMenus    ();
	virtual void slotMaskColorChanged   (QColor, QColor);
	virtual void slotVisibleRegion      (bool);
	virtual void slotRenderFrame        ();
	virtual void slotEditTimeline       ();
	// The following functions will only reach the request through from the QDVDAuthor - class
	// to m_pPixmapMenu. Neccessary bc in mainMenubar the entries are valid for all SubMenus !!!
	virtual void slotAddFrameObject (bool b=false);
	virtual void slotAddTextObject  (bool b=false);
	virtual void slotAddImageObject (bool b=false);
	virtual void slotAddMovieObject (bool b=false);

public:	// public functions
	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);

	CDVDMenuInterface *getInterface ();
	QListViewItem *createStructure  (QListViewItem *);
	QDVDAuthor *getDVDAuthor        ();
	QValueList<ButtonObject *>     &getButtons          ();
	QValueList<MovieObject *>      &getMovieObjects     ();
	QValueList<SourceFileEntry *>  &getSourceFileEntries();
	QValueList<SourceFileInfo *>   &getSourceFileInfos  ();
	DVDInfo     *getDVDInfo         ();
	UndoBuffer  *getUndoBuffer      ();
	MenuPreview *getMenuPreview     ();
	void    clear                   ();
	void    updateDVDMenu           ();
	QString name                    ();
	QColor  getColor                (int);
	void    updateDVDMenu           (QString);
	void    fitObjectDimension      (MenuObject *p=NULL);
	void    createMask              (QString &, int, bool b=false);
	void    setTabLabel             (QString &);
	int     getFormat               (int iWidth, int iHeight);
	void    appendSourceFileEntry   (SourceFileEntry *);
	void    removeSourceFileEntry   (SourceFileEntry *);
	void    removeSourceEntry       (QString &);
	bool    isSourceEntryUsed       (QString &);
	void    replaceSourceDisplayName(QString &, QString &);
	void    modifyColor             (uint , QColor, bool = false);
	void    refresh                 ();
	void    showUndoStack           ();
	bool    isMovieMenu             ();
	bool    isEmpty                 ();
	long    framesToRender          ();
	float   fps                     ();
	void    renderMenu              ();
	bool    renderingDone           ();
	void    changeSize              ();
	void    initBackground          (QString &);

protected: // Private functions ...
	void    addBackground           (QString &, QString *p=NULL, bool b=false);
	void    readBackgroundFile      (QString &);
	void    CreateTab               (QTabWidget *);

protected:
	// helper functions ...
	void setMask (QString &, uint);
	void displayMask (uint);

protected:
	QWidget		*m_pDVDMenuTab;
	QGridLayout	*m_pTabLayout;
	QGridLayout	*m_pLayout1;
	QHBoxLayout	*m_pLayout2;
	MenuPreview	*m_pPixmapMenu;

	QPushButton	*m_pButtonAddBackground;
	QPushButton	*m_pButtonAddSound;
	QPushButton	*m_pButtonShowHighlightedMask;
	QPushButton	*m_pButtonShowSelectedMask;

	CDVDMenuInterface m_DVDMenuInterface;
	DialogUndoStack  *m_pUndoStackDialog;
	QDVDAuthor       *m_pDVDAuthor;
	DVDInfo          *m_pDVDInfo;

	QPixmap m_highlightedMask;
	QPixmap m_selectedMask;
	uiDialogRenderPreview *m_pDialogRenderPreview;
	long m_iTotalFramesToRender;
	long m_iCurrentFrameToRender;
};

class VMGMenu : public DVDMenu
{
	Q_OBJECT
	 VMGMenu ();
public:
	 VMGMenu (QDVDAuthor *pDVDAuthor);
	~VMGMenu ();

	QToolBar   *getToolBar   ();
	QPopupMenu *getPopupMenu ();

private:	// Private member functions ...
	void CreateToolBar (QDVDAuthor *pDVDAuthor);
	void CreateMenuEntry (QDVDAuthor *pDVDAuthor);

private:
	// Here are the private member actions ...
	QAction *m_pActionCreateDVD;
	QAction *m_pActionCreateSVCD;
	QAction *m_pActionCreateVCD;
	QAction *m_pActionRenameMenu;
	QAction *m_pActionDeleteMenu;
	QAction *m_pActionAddFrame;
	QAction *m_pActionAddText;
	QAction *m_pActionAddImage;
	QAction *m_pActionAddMovie;
	QAction *m_pActionAddBackground;
	QAction *m_pActionAddSound;
	QAction *m_pActionAddHighlightedMask;
	QAction *m_pActionAddSelectedMask;

	QToolBar *m_pToolBar;
	QPopupMenu *m_pDVDMenuMenu;
};

#endif // MENU_H
