
/****************************************************************************
** exportsrt.cpp
**
** This file holds the implementation of the export filter for the srt 
** subtitles file.
*****************************************************************************/

#include <qfiledialog.h>

#include "global.h"
#include "sourcefileentry.h"
#include "exportsrt.h"

namespace Export
{

Srt::Srt ()
{
}

Srt::~Srt ()
{
}

bool Srt::exportSrt ( Subtitles *pSubtitles )
{
  QString qsExportFile = QFileDialog::getSaveFileName ( Global::qsCurrentPath, QObject::tr("Subtitle files (*.srt *.SRT)"), NULL, QObject::tr("Save Subtitles File") );

  // Sanity check .. Did te user choose a new project file ?
  if (qsExportFile.isNull ())
    return true;

  return writeFile ( pSubtitles, qsExportFile );
}

bool Srt::writeFile ( Subtitles *pSubtitles, QString &fileName )
{
  uint t;
  // Assign the file
  Subtitles::entry *pEntry;
  QFile projectFile ( fileName );

  if ( ! projectFile.open ( IO_Raw | IO_ReadWrite ) )
    return false;
  
  QTextStream srtStream( &projectFile );
  for ( t=0;t<pSubtitles->listOfSubtitles.count ();t++) {
    pEntry = pSubtitles->listOfSubtitles[t];
    srtStream << pEntry->iIndex << "\n";
    srtStream << pEntry->qsTimeStart << " --> " << pEntry->qsTimeStop << "\n";
    srtStream << pEntry->qsText << "\n\n";
  }
  
  projectFile.flush ( );
  projectFile.close ( );

  return true;
}

}; // End of namespace Export
