/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Feb 23 21:45:00 2004
**      by: Varol Okan using kate editor
**
**  pure virtual class as base for the three button types.
**
****************************************************************************/

#ifndef IMAGEOBJECT_H
#define IMAGEOBJECT_H

#include <qpixmap.h>
#include "qslideshow/xml_slideshow.h"
#include "menuobject.h"


class ImageObject : public MenuObject
{
	Q_OBJECT
public:
	// Public functions needed for the abstract base class.
	ImageObject (QWidget *pParent = 0);
	virtual ~ImageObject();
	virtual void drawContents(QPainter *);
	virtual void drawContents(QPainter *, int, int);
	virtual bool mouseMoveEvent        (QMouseEvent *);
	virtual bool mousePressEvent       (QMouseEvent *);
	virtual bool mouseReleaseEvent     (QMouseEvent *);
	virtual bool mouseDoubleClickEvent (QMouseEvent *);

	virtual bool readProjectFile       (QDomNode &);
	virtual bool writeProjectFile      (QDomElement &);
	virtual void createStructure       (QListViewItem *);
	virtual bool createContextMenu     (QPoint);
	virtual MenuObject *clone();

public:
	// Further public functions not dervied from the base class.
	virtual void setPixmap(QPixmap &);
	virtual void updatePixmap();
	void setManipulator(ImageManipulator &);
	void setFile (QString);
	void setZoom (float);
	QPixmap &pixmap ();
	QString &fileName();
	float    zoom ();
	virtual Modifiers *modifiers();
	ImageManipulator &manipulator();

signals:
	void signalModifyMe(MenuObject *);

	
protected:
	virtual AnimationAttribute *getSpecificAttributes (long, QString);
	bool filterColorKey ( QColor *, QValueList<QColor *>*, QValueList<QColor *>*);
	void rotate (float);

protected slots:
	virtual void slotEdit          ();
	virtual void slotProperties    ();
	virtual void slotRotate90      ();
	virtual void slotRotate180     ();
	virtual void slotRotate270     ();
	virtual void slotMatrix        ();
	virtual void slotAddFrame      ();
	virtual void slotAddText       ();
	virtual void slotAnimation     ();
	virtual void slotDefineAsButton();

protected:
	QString m_qsFileName;
	QPixmap m_pixmap;
	ImageManipulator m_imageManipulator;
};

#endif	// IMAGEOBJECT_H
