/****************************************************************************
** MenuObject
**
** Created: Sun Feb 23 21:45:00 2004
**      by: Varol Okan using kate editor
**
**  This is the base class for all that is to appear onto the MenuPreview.
** Exception are background image, and the button masks (if the user
** specifies them rather then create the button manually)
**
** The MenuPreview class is the QLabel derived class where all buttons, text
** etc is to be plaeced for a DVD-Menu.
**
** The MenuObject is the base class for TextObject, ImageObject, MovieObject,
** FrameObject, and ButtonObject.
**
** The ButtonObject in turn is a container class which can hold a
** *TextObject, ImageObject, MovieObject, AND a FrameObject.
** Please refer to the buttonobject.h - file for more detail on the
** ButtonObject.
**
****************************************************************************/

#ifndef MENUOBJECT_H
#define MENUOBJECT_H

#include <qwidget.h>
#include <qwmatrix.h>
#include <qdom.h>

#include "modifiers.h"
#include "animationattribute.h"

class QListViewItem;
class QPopupMenu;

class MenuObject : public QObject
{
	Q_OBJECT
public:
	MenuObject (QWidget *pParent);
	virtual ~MenuObject();
	virtual void drawContents         (QPainter *) = 0;
	virtual void drawContents         (QPainter *, int, int) = 0;
	virtual bool mouseMoveEvent       (QMouseEvent *) = 0;
	virtual bool mousePressEvent      (QMouseEvent *) = 0;
	virtual bool mouseReleaseEvent    (QMouseEvent *) = 0;
	virtual bool mouseDoubleClickEvent(QMouseEvent *) = 0;

	virtual bool readProjectFile      (QDomNode &);
	virtual bool writeProjectFile     (QDomElement &);
	virtual void createStructure      (QListViewItem *) = 0;
	virtual bool createContextMenu    (QPoint) = 0;
	virtual bool contains             (QPoint &);
	virtual MenuObject *clone         ();
	virtual void replaceColor         (QColor, QColor) {};

	void      update            ();
	void      setName           (QString &  );
	void      setExtractionPath (QString &  );
	void      setAnimation      (QString &  );
	void      setParent         (QWidget *  );
	void      setRect           (QRect &    );
	void      setModifiers      (Modifiers &);
	bool      drawRect                     ();
	void      setCurrentMousePos   (QPoint &);
	void      loadAnimationData (QString &, long);

	QString   &objectType       ();
	QString   &name             ();
	QString   &extractionPath   ();	// Used to store a unique path name for this object to be extracted into (movieObject)
	QString   &animation        ();
	QRect     &boundingRect     ();
	QRect     &rect             ();
	QWidget   *parent           ();
	QPoint    &currentMousePos  ();
	virtual Modifiers *modifiers();

protected:
	// This function will return Object specific attributes for Animation purposes
	virtual AnimationAttribute *getSpecificAttributes (long, QString) = 0;

public slots:
	virtual void slotDelete     ();
	virtual void slotToFront    ();
	virtual void slotToBack     ();

signals:
	void signalDefineAsButton   (MenuObject *);
	void signalMoveOnStack      (MenuObject *, int);
	void signalDeleteMe         (MenuObject *);
	void signalUpdateStructure  ();
	void signalUpdatePixmap     ();
	// Only used by Text, Frame, Button and only received if in ButtonDialog.
	void signalMaskColorChanged (QColor, QColor);

protected:
	QPopupMenu *m_pContextMenu;
	QString     m_qsObjectType;
	QString     m_qsName;
	QString     m_qsExtractionPath;
	QRect	    m_rect;
	QRect       m_boundingRect;
	QWidget    *m_pParent;
	bool        m_bDrawRect;
	Modifiers   m_modifiers;
	QString     m_qsAnimation;	// script or dataset holds also the datafilename
	QPoint      m_currentMousePos;
	QValueList<AnimationAttribute *> m_listAnimationAttributes;
};

#endif	// MENUOBJECT_H
