/****************************************************************************
** PreviewThread class
**
** Created: Tue Jan 02 22:06:51 2004
**      by: Varol Okan using Kate
**
** This class spinns off a new thread and generate a Preview of the Job 
** which was set through MediaCreator::registerWithPreviewThread.
** 
** Once the preview is generated we will call the update function in 
** the main thread ( Currently MovieObject::updatePixmap () )
**
** if after 5 seconds after termination of the thread there are no new 
** requests in the queue then the thread will be termintaed to free 
** some memory.
**
****************************************************************************/

#ifndef MEDIASCANNER_H
#define MEDIASCANNER_H

#include <qthread.h>

class MediaInfo;
class SourceFileInfo;

class ExecuteJob 
{
public:
	ExecuteJob (QObject *pTheCallingObject, QString &qsTheFileName, QImage *pTheImage, int iOffset)
	{
		qsFileName      = qsTheFileName;
		pImage          = pTheImage;
		pSourceFileInfo = NULL;
		pOrigObject     = pTheCallingObject;
		iSecondsOffset  = iOffset;
	}
	ExecuteJob (QObject *pTheCallingObject, SourceFileInfo *pSourceInfo, int iOffset)
	{
		pImage          = NULL;
		pSourceFileInfo = pSourceInfo;
		pOrigObject     = pTheCallingObject;
		iSecondsOffset  = iOffset;
	}

	int             iSecondsOffset;
	QString         qsFileName;
	QImage         *pImage;

	QObject        *pOrigObject;
	SourceFileInfo *pSourceFileInfo;
};

class MediaScanner : public QThread
{
public:
	MediaScanner      ();
	bool hasFinished  ();
	void append       (ExecuteJob *);
	void remove       (QObject *);
	bool setSemaphore (bool);

	virtual void run();

private:
	bool                     m_bHasFinished;
	bool                     m_bSemaphore;
	MediaInfo               *m_pMediaInfo;
	QValueList<ExecuteJob *> m_listExecuteFifo;
};

#endif	// MEDIASCANNER_H
