/****************************************************************************
** Interface to the GUI.
**
** Created: Tue 04 May 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This are the classes for the StructureWidget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/

#ifndef STRUCTURETOOLBAR_H
#define STRUCTURETOOLBAR_H

#include <qlistview.h>
#include <qtoolbar.h>
#include <qsize.h>

#include "uistructurewidget.h"

class MenuObject;
class MenuPreview;

class StructureItem : public QListViewItem
{
public:
	StructureItem ( MenuObject *pMenuObject, QListViewItem *pListViewItem, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
		: QListViewItem (pListViewItem, q1, q2, q3, q4, q5, q6, q7, q8) 
	  { m_pMenuObject = pMenuObject; m_pMenuPreview = NULL; }
	StructureItem ( MenuPreview *pMenuPreview, QListViewItem *pListViewItem, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
		: QListViewItem (pListViewItem, q1, q2, q3, q4, q5, q6, q7, q8) 
	  { m_pMenuPreview = pMenuPreview; m_pMenuObject = NULL; }

	virtual ~StructureItem    ()  {};
	virtual int rtti          () const { return 5000; };

	void createContextMenu    ( QPoint );

private:
	MenuObject  *m_pMenuObject;
	MenuPreview *m_pMenuPreview;
	static int RTTI;
};

class StructureToolBar : public QToolBar
{
	Q_OBJECT

public:
	 StructureToolBar (const QString &, QMainWindow *, QWidget *, bool b=FALSE, const char *n=0, WFlags f=0);
	~StructureToolBar ();

	//	QListView *listView();
	QListViewItem *clean   ( bool );

	virtual QSize sizeHint () const;

public slots:
	virtual void slotRightClickedOnStructure (QListViewItem *, const QPoint &, int);
	virtual void slotRightClickedOnTitleset  (QListViewItem *, const QPoint &, int);

private:
	uiStructureWidget *m_pStructureWidget;
};

#endif // STRUCTURETOOLBAR_H

