/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Feb 23 21:45:00 2004
**      by: Varol Okan using kate editor
**
**  pure virtual class as base for the three button types.
**
****************************************************************************/

#ifndef TEXTOBJECT_H
#define TEXTOBJECT_H

#include <qobject.h>
#include "menuobject.h"

class QPopupMenu;

class TextObject : public MenuObject
{
	Q_OBJECT
public:
	TextObject (QWidget *pParent = 0);
	virtual ~TextObject ();
	virtual void drawContents          (QPainter *);
	virtual void drawContents          (QPainter *, int , int);
	virtual bool mouseMoveEvent        (QMouseEvent *);
	virtual bool mousePressEvent       (QMouseEvent *);
	virtual bool mouseReleaseEvent     (QMouseEvent *);
	virtual bool mouseDoubleClickEvent (QMouseEvent *);

	virtual bool readProjectFile       (QDomNode &);
	virtual bool writeProjectFile      (QDomElement &);
	virtual void createStructure       (QListViewItem *);
	virtual bool createContextMenu     (QPoint);
	virtual MenuObject *clone          (  );
	virtual void replaceColor          (QColor, QColor);

	virtual void setFont               (QFont &);
	virtual void setText               (QString &);
	virtual void setTextAlign          (QPoint &);
	virtual void setStyleStrategy      (int);
	virtual void setForegroundColor    (QColor &);
	virtual void setBackgroundColor    (QColor &);
	virtual QFont   &getFont           ();
	virtual QString &getText           ();
	virtual QPoint  &getTextAlign      ();
	virtual int      getStyleStrategy  ();
	virtual QColor  &getForegroundColor();
	virtual QColor  &getBackgroundColor();

private:
	void drawSemiTransparent           (QPainter *);

protected:
	virtual AnimationAttribute *getSpecificAttributes (long, QString);

public slots:
	virtual void slotEdit              ();
	virtual void slotMatrix            ();
	virtual void slotAddFrame          ();
	virtual void slotAddImage          ();
	virtual void slotAddMovie          ();
	virtual void slotDefineAsButton    ();

protected:
	QString     m_qsText;
	QFont       m_Font;
	QPoint      m_ptTextAlign;
	QColor      m_colorForeground;
	QColor      m_colorBackground;
	int         m_iStyleStrategy;
};


#endif	// TEXTOBJECT_H
