/****************************************************************************
** Interface to the GUI.
**
** Created: Tue 08 May 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will create a toolbar, which holds only one widget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/

#ifndef COLORTOOLBAR_H
#define COLORTOOLBAR_H

#include <qtoolbar.h>
#include <qsize.h>

class QListView;

class DVDMenu;

class QColorFrame : public QFrame
{
	Q_OBJECT
public:
	QColorFrame (int, QColor, QWidget *p=0, const char *n=0, WFlags f=0);
	QColor getColor   ();
	void   setColor   (QColor);

signals:
	void signalRightButtonClicked (int);

protected:
	// Overloaded member function ...
	virtual void mouseReleaseEvent (QMouseEvent *);

private:
	int m_iWhichColor;
};


class ColorToolBar : public QToolBar
{
	Q_OBJECT

public:
	 ColorToolBar (const QString &, QMainWindow *, QWidget *, bool b=FALSE, const char *n=0, WFlags f=0);
	~ColorToolBar ();

	QColor getColor   (uint);
	void   setColor   (uint, QColor);
	void   setDVDMenu (DVDMenu *);

//	void   modifyColor (QColor, uint, void *);
//signals:
//	void signalChangeMaskColor (QColor, uint);

protected slots:
	virtual void slotColorClicked (int);


private:
	QColorFrame *m_colorFrames[4];
	DVDMenu *m_pCurrentDVDMenu;
};

#endif // COLORTOOLBAR_H


