
#ifndef __EXPORT_DVDAUTHOR_H__
#define __EXPORT_DVDAUTHOR_H__

#include <qvaluelist.h>

class SourceFileEntry;
class CXmlDVDAuthor;
class ButtonObject;
class CXmlSpumux;
class QDVDAuthor;
class VMGMenu;
class DVDMenu;


namespace Export
{

class JumpTable 
{
public:
	JumpTable ();

	// The jumpIndex is the number assigned to g3
	// the menu designated to handle the jumpTable 
	// will use this index to jump to the associated 
	// title / chapter.
	int             iJumpIndex;
	int             iTitle;
	int             iMenu;
	int             iChapter;
	ButtonObject   *pButton;
	QString         qsAction;
};

class ExportTitleset 
{
public:
	 ExportTitleset              (                   );
	~ExportTitleset              (                   );
	int  findMenu                ( DVDMenu *         );
	int  findTitle               ( SourceFileInfo  * );
	int  getTotalChapters        ( SourceFileInfo  * );
	bool checkForPrePostCommands ( SourceFileEntry *, bool b=false );

	int                           iTitlesetNumber;
	bool                          bSetByUser;
	QString                       qsFormat;
	QValueList<DVDMenu *>         listMenus;              // all menus which fit the format.
	QValueList<JumpTable *>       listJumpTable;          // the jump table 
	QValueList<SourceFileEntry *> listSourceFileEntries;
};


class DVDAuthor
{
public:
   DVDAuthor  ( QDVDAuthor * );
  ~DVDAuthor  ();
  
  bool exportXml ();
  bool createXml ();
  bool createXml ( QString & );

private:
  ExportTitleset *findTitleset ( SourceFileInfo * );
  ExportTitleset *findTitleset ( ButtonObject * ); // currently unused ...
  ExportTitleset *findTitleset ( DVDMenu * );
  ExportTitleset *findTitleset ( int );
  JumpTable      *findJumpTableEntry ( ButtonObject * );
  int  getHighestTitlesetNumber();
  int  getFirstEmptyTitleset   ();
  bool populateListOfTitlesets ();
  bool stowMenusAway           ();
  bool createJumpTable         ();
  bool createNoMenuDVD         ( QString & );
  bool createDVDAuthorXml      ( QString & );
  bool cleanUpSourceFileEntries( QValueList<SourceFileEntry *> & );
  void cleanSourceFileEntris   ();

  ExportTitleset *addToTitleset(SourceFileEntry *, int, bool b=false     );
  bool addToTitleset( CXmlDVDAuthor::titleset_struct *, SourceFileEntry *);
  bool addToTitleset( CXmlDVDAuthor::titles_struct *,   SourceFileEntry *);
  bool addToTitleset( CXmlDVDAuthor::pgc_struct *,      SourceFileEntry *);
  bool addToTitleset( CXmlDVDAuthor::pgc_struct *,      SourceFileInfo  *);
  bool addToMenu    ( CXmlDVDAuthor::titleset_struct *, ExportTitleset  *);
  bool addToMenu    ( CXmlDVDAuthor::menus_struct *,    ExportTitleset  *);
  bool addToMenu    ( CXmlDVDAuthor::pgc_struct *,      ExportTitleset  *);
  bool addToMenu    ( CXmlDVDAuthor::titleset_struct *, DVDMenu         *);
  bool addToMenu    ( CXmlDVDAuthor::menus_struct *,    DVDMenu         *);
  bool addToMenu    ( CXmlDVDAuthor::pgc_struct *,      DVDMenu         *);
  bool addToVideo   ( CXmlDVDAuthor::video_struct *,    QString&,QString&);
  bool addToVideo   ( CXmlDVDAuthor::video_struct *,    int,int,QString &);

  DVDMenu *getMenuFromButton ( ButtonObject * );

  bool m_bInsertComments;
  QDVDAuthor *m_pDVDAuthor;
  QValueList<DVDMenu *>         m_listOfAllMenus; 
  QValueList<ExportTitleset *>  m_listTitlesets;
  QValueList<SourceFileEntry *> m_listNewEntries;
};

class Spumux
{
public:
   Spumux ();
  ~Spumux ();

  bool createXml ( DVDMenu * );
  bool createXml ( SourceFileInfo * );
  bool createXml ( );

protected:
  bool correctOverlappingButtons ( QValueList<QRect> &, int, int );

};

}

#endif // __EXPORT_DVDAUTHOR_H__
