/****************************************************************************
** importsrt.cpp
**
** This file holds the implementation of the import filter for the srt 
** subtitles file.
*****************************************************************************/

#include <qfile.h>
#include <qobject.h>
#include <qfiledialog.h>

#include "global.h"
#include "importsrt.h"

namespace Import
{

Srt::Srt ()
{
}

Srt::~Srt ()
{
  for (uint t=0;t<m_listOfEntries.count(); t++)
    delete m_listOfEntries[t];
  m_listOfEntries.clear ();
}

bool Srt::import ()
{
  QString qsImportFile = QFileDialog::getOpenFileName ( Global::qsCurrentPath, QObject::tr("Subtitle files (*.srt *.SRT)"), NULL, QObject::tr("Open Subtitles File") );

  // Sanity check .. Did te user choose a new project file ?
  if (qsImportFile.isNull ())
    return true;

  return readFile ( qsImportFile );
}

bool Srt::readFile ( QString &fileName )
{
  // Assign the file
  Subtitles::entry *pEntry;
  QString line, lineIndex, lineTimestamp, lineText;
  QFile projectFile ( fileName );
  if (!projectFile.open ( IO_Raw | IO_ReadWrite ) )
    return false;
  
  QTextStream srtStream( &projectFile );

  lineIndex = srtStream.readLine();
  while ( !srtStream.atEnd() ) {
    // first we are looking for the beginning of an entry which ist the index number
    if ( ( lineIndex.toInt ( ) > 0 ) && ( ! isTimeStamp ( lineIndex ) ) ) {
      pEntry = new Subtitles::entry;
      pEntry->iIndex = lineIndex.toInt ();
      lineIndex = readEntry ( &srtStream,  pEntry );
      m_listOfEntries.append ( pEntry );
    }
    else
      lineIndex = srtStream.readLine();
  }

  projectFile.close();
  return true;
}

QString Srt::readEntry ( QTextStream *pStream, Subtitles::entry *pEntry )
{
  int t;
  bool bTrailing = true;
  QString line, lineIndex, lineTimestamp, lineText;
  QStringList listStrings;
  // Found the first line ... get the timestamp
  lineTimestamp = pStream->readLine ();
  while ( ! isTimeStamp ( lineTimestamp ) )
    lineTimestamp = pStream->readLine ();
  lineText = QString ();
  //  lineText = pStream->readLine () + "\n";
  line = pStream->readLine ();

  while ( ( line.toInt ( ) == 0 ) && ( ! isTimeStamp ( line ) ) && 
	 ( ! pStream->atEnd () ) ) {
    // while ( line.find ( '-' ) <= 2 && line.find ('-') > -1 )  {
    listStrings.append ( line );
    line = pStream->readLine ();
  }

  // Here we remove the trailing empty lines ...
  for (t=listStrings.count ()-1;t>=0;t--) {
    if ( ( listStrings[t].length () < 2 ) && bTrailing )
      continue;
    // once we get here, we found a non empty line at the end.
    // So from now on everything is valid.
    bTrailing = false;
    lineText = listStrings[t] + "\n" + lineText;
  }

  pEntry->qsTimeStart = getTimeRange ( lineTimestamp, true  );
  pEntry->qsTimeStart.replace ( ',', '.' );
  pEntry->iTimeStart  = getTimeFromString ( pEntry->qsTimeStart );
  pEntry->qsTimeStop  = getTimeRange ( lineTimestamp, false );
  pEntry->qsTimeStop.replace ( ',', '.' );
  pEntry->iTimeStart  = getTimeFromString ( pEntry->qsTimeStop );
  pEntry->qsText      = lineText;

  return line;
}

bool Srt::isTimeStamp ( QString &line )
{
  line = line;
  
  if ( ( line.find ("-->") > -1 ) && ( line.contains (':') >= 3) )
    return true;
  return false;
}

QString Srt::getTimeRange ( QString &line, bool bStartTime )
{
  QString qsReturn;
  int iPos = line.find ( "-->" );
  
  if ( iPos < 1 )
    return qsReturn;
  if ( bStartTime )
    qsReturn = line.left ( iPos ).stripWhiteSpace ( );
  else
    qsReturn = line.right ( line.length() - iPos -3 ).stripWhiteSpace ( );

  return qsReturn;
}

long Srt::getTimeFromString ( QString &qsTime )
{
  long iMSeconds = -1;
  QTime theTime;
  iMSeconds = (long)theTime.msecsTo ( QTime::fromString ( qsTime ) );

  return iMSeconds;
}


}; // End of namespace Import
