/****************************************************************************
** CXmlSlideshow - class
**
** Created: ?
**      by: Varol Okan using kate editor
**
** This class handles reading / writing of the XML files for the slideshow.
**
****************************************************************************/

#ifndef XML_SLIDESHOW_H
#define XML_SLIDESHOW_H

#include <qstring.h>
#include <qstringlist.h>
//#include <qdom.h>

#define SLIDESHOW_DOCTYPE	""
// Here we define all attributes for the structures.
#define SLIDESHOW_DELAY		"delay"
#define SLIDESHOW_FILTER_DELAY	"filter_delay"
#define SLIDESHOW_NAME		"name"
#define SLIDESHOW_XRES		"xres"
#define SLIDESHOW_YRES		"yres"
#define SLIDESHOW_BACKGROUND	"background"
#define SLIDESHOW_AUDIO_LIST	"audio_list"
#define IMG_SRC			"src"
#define IMG_TEXT		"text"
#define IMG_WIDTH		"width"
#define IMG_HEIGHT		"height"
#define IMG_ROTATE		"rotate"
#define IMG_DURATION		"duration"
#define EFFECT_NAME		"name"
#define EFFECT_X0		"x0"
#define EFFECT_Y0		"y0"
#define EFFECT_X1		"x1"
#define EFFECT_Y1		"y1"
#define EFFECT_XE0		"xe0"
#define EFFECT_YE0		"ye0"
#define EFFECT_XE1		"xe1"
#define EFFECT_YE1		"ye1"
#define EFFECT_SCROLL		"scroll"
#define FILTER_NAME		"name"
#define FILTER_DURATION		"duration"
#define FILTER_SUBTITLE		"subtitle"
/*
<IMG ...>
	<EFFECT ...></EFFECT>
</IMG>
<FILTER ...></FILTER>
*/
// Container class for pre processing information of images, before usage.

#include "modifiers.h"

class CXmlSlideshow
{
public:
	class time_object {
		public:
		time_object ();
		virtual ~time_object (){};
		virtual bool readXml (QDomElement *) = 0;
		virtual bool writeXml(QDomDocument *, QDomElement *) = 0;
		virtual time_object& operator = (time_object &) = 0;
		QString node_name;
		float fDuration;
		float fStartTime;
		float fEndTime;
		// The modifier is a internal structur to process this item before 
		// continuing to the command line tools. 
		// (E.g. img can have a ImageManipulator stored here)
		void *pModifier;
	};
	class effect_struct	{
		public:
		effect_struct ();
		bool readXml (QDomElement *);
		bool writeXml(QDomDocument *, QDomElement *);
		effect_struct& operator = (effect_struct &);
		QString node_name;	// effect
		QString name;		// either crop/kenburns/scroll
		int x0;
		int y0;
		int x1;
		int y1;
		int xe0;
		int ye0;
		int xe1;
		int ye1;
		QString scroll;	// either left or right
	};
	class img_struct : public time_object
	{
		public:
		img_struct ();
		virtual ~img_struct ();
		bool readXml (QDomElement *);
		bool writeXml(QDomDocument *, QDomElement *);
		time_object& operator = (time_object &);
		QString src;	// the location of this image.
		QString text;	// the text of this image.
		int width;
		int height;
		float rotate;
		effect_struct effect;
	};
	class filter_struct : public time_object
	{
		public:
		filter_struct ();
		bool readXml (QDomElement *);
		bool writeXml(QDomDocument *, QDomElement *);
		time_object& operator = (time_object &);
		QString name;	// the type of filter, e.g. crossfade/fadein/fadeout
		QString subtitle;
	};
public:
	 CXmlSlideshow ();
	~CXmlSlideshow ();

	bool readXml  ();
	bool readXml  (QString &fileName);
	bool writeXml ();
	bool writeXml (QString &fileName);
	// copy the object over ...
	CXmlSlideshow &operator = (CXmlSlideshow &);

	CXmlSlideshow::time_object	*getTimeObject(uint iObjNo);
	CXmlSlideshow::img_struct	*addImg();
	CXmlSlideshow::img_struct	*getImg(uint iImgNo);
	CXmlSlideshow::filter_struct	*addFilter();
	CXmlSlideshow::filter_struct	*getFilter(uint iImgNo);
	int								 findImg (img_struct *);

	void clear       ();
	uint count       ();
	uint countImg    ();
	uint countFilter ();

public:
	QString node_name;
	QString background;
	QStringList audio_list;
	QString slideshow_name;
	int delay;
	int filter_delay;
	int xres;
	int yres;
	// Note filter and img are on the same level, to get a continous structure as stored in the file we need to check the iPosition of those structures ...
	QValueList<time_object *> m_listTimeObjects;
	img_struct		**ppArrayImg;
	filter_struct	**ppArrayFilter;
};


/////////////////////////////////////////////////////////
//
// Following is the structure of spumux-xml files.
//
/////////////////////////////////////////////////////////
//<slideshow delay="sec" background="background.jpg">
// <img src="img_name" width="width" height="height />
// <img ... >
//</slideshow>
/////////////////////////////////////////////////////////

#endif // XML_SLIDESHOW_H
