/****************************************************************************
** Shadow object 
**
** Created: Sun Aug 08 21:45:00 20046
**      by: Varol Okan using XEmacs
**
**  This class will create a shadow of the associated MenuObject
**
****************************************************************************/

#ifndef SHADOW_H
#define SHADOW_H

#include <qimage.h>

#include "imageobject.h"

//class QPainter;
//class QDomNode;
//class QDomElement;

class ShadowObject : public ImageObject
{
  Q_OBJECT
public:
  enum enType { 
    TYPE_SHADOW,     // Shadow under object
    TYPE_REFLECTION, // Shadow reflection (shades of grey)
    TYPE_MIRROR      // Object is mirrored and stretched accordingly
  };

  ShadowObject ( MenuObject *, QWidget *p=0 );
  virtual ~ShadowObject ( );

  virtual void drawContents         ( QPainter      *, int, int);
  virtual void drawContents         ( QPainter      * );
  //virtual bool mouseMoveEvent       ( QMouseEvent * );
  virtual bool mousePressEvent      ( QMouseEvent   * );
  virtual bool mouseReleaseEvent    ( QMouseEvent   * );
  virtual bool mouseDoubleClickEvent( QMouseEvent   * );
  
  virtual bool readProjectFile      ( QDomNode      & );
  virtual bool writeProjectFile     ( QDomElement   & );
  virtual void createStructure      ( QListViewItem * );
  virtual bool createContextMenu    ( QPoint   );
  virtual MenuObject *clone         ( MenuObject    * );
  virtual void updateShadow         ( );
  
  ShadowObject &operator =          ( ShadowObject & );
  
  bool filterColorKeys  ( QImage      & );

  void setTransparency  ( float );
  void setBlur          ( int   );
  void setDistance      ( float );
  void setSunAngle      ( float );
  void setColor         ( QColor );

  float  transparency   ( ); // [ 0.0 .. 1.0 ]
  int    blur           ( );
  float  distance       ( );
  float  sunAngle       ( );
  QColor &color         ( );

  int deltaX            ( );
  int deltaY            ( );

protected:
  // This function will return Object specific attributes for Animation purposes
  virtual AnimationAttribute *getSpecificAttributes (long, QString);

private:
  bool filterColorKey ( QColor *, int, QValueList<QColor *> *, QValueList<QColor *>* );
  void blurShadow     ( );
  void createShadow   ( MenuObject *, int );
  void createMirror   ( MenuObject *, int );

  MenuObject  *m_pMenuObject; // the object which has the shadow
  QImage       m_imageShadow; // the shadow is staored as a QImage - object
  enType       m_enType;

  // Shadow attributes
  QColor m_color;
  float  m_fTransparency; // [ 0.0 .. 1.0 ]
  float  m_fDistance;     //  
  int    m_iBlurRadius;   //  [ 3 .. 23 ]
  float  m_fSunAngle;     //  in degrees
  const float m_fSunElevation; // default to 45% non changeable

  // Calculaed values ...
  int m_iDeltaX;
  int m_iDeltaY;
};

#endif // SHADOWOBJECT_H

