/****************************************************************************
** StructureToolBar - class
**
** Created: Tue May 04 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will create a toolbar, which holds only one widget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/
#include <qmainwindow.h>
#include <qlistview.h>

#include "dvdmenu.h"
#include "menupreview.h"
#include "menuobject.h"
#include "structuretoolbar.h"

StructureToolBar::StructureToolBar (const QString &qsLabel, QMainWindow *pMainWindow, QWidget *pParent, bool bNewLine, const char *pName, WFlags f)
	: QToolBar (qsLabel, pMainWindow, pParent, bNewLine, pName, f)
{
	setResizeEnabled (true);
	setMovingEnabled (true);
	pMainWindow->addDockWindow (this, Left);
	m_pStructureWidget = new uiStructureWidget ( this );
	connect( m_pStructureWidget->m_pListViewStructure, SIGNAL( rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT (slotRightClickedOnStructure (QListViewItem *, const QPoint &, int)) );
	connect( m_pStructureWidget->m_pListViewTitleset , SIGNAL( rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT (slotRightClickedOnTitleset  (QListViewItem *, const QPoint &, int)) );
}

StructureToolBar::~StructureToolBar ()
{
	delete m_pStructureWidget;
}

/*QListView *StructureToolBar::listView()
{
	return m_pStructureWidget->m_pListViewStructure;
	}*/

QListViewItem *StructureToolBar::clean ( bool bStructureView )
{
  QListViewItem *pMainItem;
  QListView     *pListView;
  
  if ( bStructureView ) {
    pListView =   m_pStructureWidget->m_pListViewStructure;
    pListView->clear ();
    pMainItem = new QListViewItem ( pListView, tr ("DVD Project") );
  }
  else {
    pListView = m_pStructureWidget->m_pListViewTitleset;
    pListView->clear ();
    pMainItem = new QListViewItem ( pListView, tr ("VMGM") );
  }
  pListView->setSorting ( -1, TRUE );
  pMainItem->setExpandable (TRUE);
  pMainItem->setOpen (TRUE);

  return pMainItem;
}

QSize StructureToolBar::sizeHint () const
{
//	return QSize (QToolBar::sizeHint().width(), 200);
	return QSize (250, 200);
}

void StructureToolBar::slotRightClickedOnStructure (QListViewItem *pItem, const QPoint &pos, int iColumn)
{
  if ( ( ! pItem ) || (iColumn == -1) || (pItem->rtti () != 5000 ) )
    return; 
  StructureItem *pStructureItem = (StructureItem *)pItem;
  pStructureItem->createContextMenu (pos);
}

void StructureToolBar::slotRightClickedOnTitleset (QListViewItem *, const QPoint &, int)
{
  printf ("StructureToolBar::slotRightClickedOnTitleset\n");
}

void StructureItem::createContextMenu    ( QPoint p )
{
  QString qsText  = text ( 1 );
  bool bIntro     = false;
  bool bSoundFile = false;
  if ( text ( 0 ).find ( "Intro file" ) > -1 )
    bIntro = true;
  else if ( text ( 0 ).find ( "Sound file" ) > -1 )
    bSoundFile = true;

  if ( m_pMenuObject )
    m_pMenuObject->createContextMenu  ( p );    
  else if ( m_pMenuPreview )
    m_pMenuPreview->createContextMenu ( p );
  else if ( m_pDVDMenu ) {
    if ( bSoundFile )
      m_pDVDMenu->createSoundMenu ( p, qsText );
    else
      m_pDVDMenu->createIntroExtroMenu  ( p, bIntro, qsText );
  }
}

