/*****************************************************************************
 ** Class QSubtitles
 **
 ** This is a sub-project to 'Q' DVD-Author to handle the subtitles - tab
 ** of the main application
 **
 *****************************************************************************/

#include <qtable.h>
#include <qpushbutton.h>

#include "importsrt.h"
#include "subtitles.h"


Subtitles::Subtitles (QWidget *pParent, const char *pName, WFlags flags)
  : uiSubtitles ( pParent, pName, flags)
{
  
  m_pTableSubtitles->setShowGrid ( true );
  m_pTableSubtitles->setNumCols  ( 4 );
  
  connect ( m_pButtonImport, SIGNAL (clicked()), this, SLOT(slotImport () ) );
}

Subtitles::~Subtitles ()
{
}

void Subtitles::slotImport ()
{
  uint t;
  Import::Srt::entry *pEntry;
  Import::Srt theImporter;
  if ( theImporter.import ( ) ) {
    m_pTableSubtitles->setNumRows ( theImporter.m_listOfEntries.count() );
    for (t=0;t<theImporter.m_listOfEntries.count();t++) {
      pEntry = theImporter.m_listOfEntries[t];
      m_pTableSubtitles->setText (t, 0, QString ("%1").arg(pEntry->iIndex ) );
      m_pTableSubtitles->setText (t, 1, pEntry->qsTimeStart );
      m_pTableSubtitles->setText (t, 2, pEntry->qsTimeStop  );
      m_pTableSubtitles->setText (t, 3, pEntry->qsText      );
    }
  }
}



