/*****************************************************************************
 ** Class QSubtitles
 **
 ** This class handles the subtitles - tab of the main QDVDAuthor 
 ** application
 **
 *****************************************************************************/

#ifndef SUBTITLESGUI_H
#define SUBTITLESGUI_H

#include <qlabel.h>
#include <qdragobject.h>

#include "uisubtitles.h"

class Subtitles;
class QDVDAuthor;
class QGridLayout;
class SubtitlesGui;
class SourceFileInfo;
class MediaInterface;

class MediaLabel : public QLabel
{
  Q_OBJECT
public:
           MediaLabel ( SubtitlesGui *, QWidget *p, const char *n=NULL, WFlags f=0 );
  virtual ~MediaLabel ( );

protected:
   virtual void dropEvent      ( QDropEvent * );
   virtual void dragEnterEvent ( QDragEnterEvent * );

private:
   SubtitlesGui *m_pSubtitlesGui;
};


class SubtitlesGui : public uiSubtitles
{
  Q_OBJECT
public:
   SubtitlesGui ( QDVDAuthor *, QWidget *p, const char * n=0, WFlags f=0 );
  ~SubtitlesGui ( );

public slots:
  virtual void slotNewPosition          ( int, const QString & );
  virtual void slotNewPosition          ( long );
  virtual void slotCloseSource          ( );
  virtual void slotMediaFB              ( );
  virtual void slotMediaBack            ( );
  virtual void slotMediaStop            ( );
  virtual void slotMediaPlay            ( );
  virtual void slotMediaPlayStop        ( );
  virtual void slotMediaFF              ( );
  virtual void slotAddNew               ( );
  virtual void slotStart                ( );
  virtual void slotEnd                  ( );
  virtual void slotImport               ( );
  virtual void slotExport               ( );
  virtual void slotClear                ( );
  virtual void slotDelete               ( );
  virtual void slotPrepend              ( );
  virtual void slotAppend               ( );
  virtual void slotTextOnly             ( );
  virtual void slotSearchText           ( );
  virtual void slotFontColor            ( );
  virtual void slotBackgroundColor      ( );
  virtual void slotFontFamilyChanged  (int);
  virtual void slotFontStyleChanged   (int);
  virtual void slotFontSizeChanged    (int);
  virtual void slotScriptChanged      (int);
  virtual void slotVolumeChanged      (int);
  virtual void slotPositionChanged    (int);
  virtual void slotTransparencyChanged(int);
  virtual void slotRight             (bool);
  virtual void slotCenter            (bool);
  virtual void slotLeft              (bool);
  virtual void slotJustify           (bool);
  virtual void slotVCenter           (bool);
  virtual void slotFit               (bool);
  virtual void slotUnderline         (bool);
  virtual void slotStrikeout         (bool);

public:
  void insertDraggedObject  ( QDropEvent *, QImage &  );
  void insertDraggedText    ( QDropEvent *, QString & );
  Subtitles *getSubtitles   ( bool b=false );
  void releaseSourceFileInfo                   ( );
  void createTableEntries                      ( );

private:
  void initMe                                  ( );
  void displayRow                          ( int );
  void updateFont                         ( uint );
  int  findString       ( QStringList &, QString );
  bool createSubtitles                         ( );
  void updateButtons                           ( );
  void resetMediaWidget                        ( );
  QFont &getFont                               ( );
  void setBackgroundColor      ( const QColor  & );
  void setForegroundColor            ( QColor  & );  
  void initNewSourceFileInfo                   ( );
  SourceFileInfo *findSourceFileInfo ( QString & );

private:
  MediaLabel     *m_pDragLabel;
  QGridLayout    *m_pLayout;
  MediaInterface *m_pMediaInterface;
  SourceFileInfo *m_pSourceFileInfo;
  Subtitles      *m_pSubtitles;
  QDVDAuthor     *m_pDVDAuthor;
  QString         m_strCurrentTime;
  QString         m_strStartTime;
  QString         m_strEndTime;
  QFont	          m_qfFont;
  int             m_iAlignement;
  QColor          m_backgroundColor;
  QColor          m_foregroundColor;
};
 
#endif // SUBTITLESGUI_H
