/****************************************************************************
** Form implementation generated from reading ui file 'uidialogtemp.ui'
**
**   Created : Sat Mar 5 22:05:28 2005
**        by : The User Interface Compiler ($Id: dialogtemp.cpp,v 1.44 2007/10/05 05:45:03 qdvdauthor Exp $)
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include <qvariant.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfile.h>
#include <qdir.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qtable.h>
#include <qfileinfo.h>
#include <qapplication.h>
#include <qcursor.h>

#include "global.h"
#include "utils.h"
#include "messagebox.h"
#include "uitemptab.h"
#include "dialogtemp.h"

/*
 *  Constructs a DialogTemp as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
DialogTemp::DialogTemp( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
	m_iTotalSize = 0;
	QCursor myCursor (QCursor::WaitCursor);
	QApplication::setOverrideCursor (myCursor);

	if ( !name )
		setName( "DialogTemp" );
	setSizeGripEnabled( TRUE );
	DialogTempLayout = new QGridLayout( this, 1, 1, 11, 6, "DialogTempLayout"); 

	m_pTabWidget = new QTabWidget( this, "m_pTabWidget" );
	QColor arrayColors[3];
	arrayColors[0] = QColor( 57, 238, 187 );
	arrayColors[1] = QColor( 238, 57, 187 );
	arrayColors[2] = QColor( 187, 238,  57 );
	uint t, i, iSize;
	unsigned long iTotalSize;

	Utils theUtils;
	QStringList listOfProjects = theUtils.getProjectsFromTempPath();
	QStringList listDirectoryTree;
	QString qsProjectTemp;
	QFileInfo fileInfo;
	iTotalSize = 0;
	for (t=0;t<listOfProjects.count();t++)	{
		qsProjectTemp = Global::qsTempPath + QString ("/") + listOfProjects[t];
		QWidget *pTab = new QWidget( m_pTabWidget, QString ("tab_%1").arg(t) );
		m_pTabWidget->insertTab( pTab, QString("") );    
		QVBoxLayout *pTabLayout = new QVBoxLayout( pTab, 2, 4, QString("tabLayout_%1").arg(t)); 
		m_pTabWidget->changeTab( pTab, listOfProjects[t] );

		m_listTabs.append( new uiTempTab  ( pTab, QString("uiTempTab_%1").arg(t)));
		connect (m_listTabs[t]->m_pButtonDelete, SIGNAL (clicked()), this, SLOT(slotDelete()));
		m_listTabs[t]->m_pFrameTempTab->setPaletteBackgroundColor( arrayColors[t%3] ); // roll over at 3
//		m_listTabs[t]->setPaletteBackgroundColor( arrayColors[t%3] ); // roll over at 3
		pTabLayout->addWidget (m_listTabs[t]);
		// Next we set all values ...
		m_listTabs[t]->m_pLabelHeader->setText (qsProjectTemp);
		// So next we take care of the preview ...
		QFile theFile (qsProjectTemp + QString ("/Main Menu VMGM/background/rendered_00000001.png"));
		// In case the Menu was never rendered, we are sure to have the background.jpg file.
		if (!theFile.exists())
			theFile.setName (qsProjectTemp + QString ("/Main Menu VMGM/background.jpg"));
		if (!theFile.exists())
			theFile.setName (qsProjectTemp + QString ("/background.jpg"));
		QImage theImage(theFile.name());
		theImage = theImage.smoothScale (m_listTabs[t]->m_pLabelPreview->width(), m_listTabs[t]->m_pLabelPreview->height(), QImage::ScaleMin);
		QPixmap thePixmap;
		thePixmap.convertFromImage(theImage);
		m_listTabs[t]->m_pLabelPreview->setPixmap (thePixmap);
		// Next we take care of the Table.
		listDirectoryTree = getDirectoryTree (qsProjectTemp);
		m_listTabs[t]->m_pTable->insertRows (0, listDirectoryTree.count());
		m_listTabs[t]->m_pTable->setColumnWidth (0, 350);
		iTotalSize = 0;
		for (i=0;i<(uint)m_listTabs[t]->m_pTable->numRows();i++)	{
			iSize = getDirectorySize (listDirectoryTree[i]);
			iTotalSize += iSize;
			m_listTabs[t]->m_pTable->setText (i, 1, QString ("%1").arg(iSize));
			m_listTabs[t]->m_pTable->setText (i, 0, listDirectoryTree[i].replace (qsProjectTemp, "...") + QString ("/"));
		}
		m_listTabs[t]->m_pTable->insertRows (i, 1);
		m_listTabs[t]->m_pTable->setText (i, 1, QString ("%1").arg(iTotalSize));
		m_listTabs[t]->m_pTable->setText (i, 0, ".../");
		m_iTotalSize += iTotalSize;
		m_listSizes.append (iTotalSize);
		// Finally we update the one label that does only require it once ...
		QString qsFormat ("MMM dd yyyy hh:mm:ss");
		fileInfo.setFile (qsProjectTemp + QString ("/background.jpg"));
		m_listTabs[t]->m_pLabelModified->setText (tr("<font size=\"-1\"><b>%1</b></font>").arg(fileInfo.lastModified().toString(qsFormat)));
	}
    
    DialogTempLayout->addMultiCellWidget( m_pTabWidget, 0, 0, 0, 5 );

    buttonHelp = new QPushButton( this, "buttonHelp" );
    buttonHelp->setAutoDefault( TRUE );

    DialogTempLayout->addWidget( buttonHelp, 1, 0 );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );

    DialogTempLayout->addWidget( buttonOk, 1, 4 );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setAutoDefault( TRUE );

    DialogTempLayout->addWidget( buttonCancel, 1, 5 );
    Horizontal_Spacing2 = new QSpacerItem( 130, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    DialogTempLayout->addItem( Horizontal_Spacing2, 1, 1 );
    Horizontal_Spacing2_2 = new QSpacerItem( 130, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    DialogTempLayout->addItem( Horizontal_Spacing2_2, 1, 3 );

    m_pLabelGeneral = new QLabel( this, "m_pLabelGeneral" );
    m_pLabelGeneral->setAlignment( int( QLabel::AlignVCenter ) );

    DialogTempLayout->addWidget( m_pLabelGeneral, 1, 2 );
    languageChange();
    resize( QSize(787, 442).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    QApplication::restoreOverrideCursor ();

    updateLabels ();
}

/*
 *  Destroys the object and frees any allocated resources
 */
DialogTemp::~DialogTemp()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void DialogTemp::languageChange()
{
    setCaption( tr( "Temp Dialog" ) );
    buttonHelp->setText( tr( "&Help" ) );
    buttonHelp->setAccel( QKeySequence( tr( "F1" ) ) );
    buttonOk->setText( tr( "&OK" ) );
    buttonOk->setAccel( QKeySequence( QString::null ) );
    buttonCancel->setText( tr( "&Cancel" ) );
    buttonCancel->setAccel( QKeySequence( QString::null ) );
    m_pLabelGeneral->setText( tr( "<p align=\"center\">Found<b> 3 </b>projects : Total = <b>1.25 GB</b></p>" ) );
}

QStringList DialogTemp::getDirectoryTree (QString qsProjectTemp)
{
	uint t;
	QStringList listDirectoryTree;
	QString qsPath;
	QDir theDir (qsProjectTemp);
	theDir.setFilter (QDir::Dirs);

	for (t=0;t<theDir.count();t++)	{
		
		if ( (theDir[t] == ".") ||(theDir[t] == "..") )
			continue;
		qsPath = qsProjectTemp + QString("/") + theDir[t];
		listDirectoryTree += getDirectoryTree (qsPath);
		listDirectoryTree.append(qsPath);
	}
	return listDirectoryTree;
}

unsigned long DialogTemp::getDirectorySize (QString qsPath)
{
  uint t;
  unsigned long iSize = 0;
  QFileInfo fileInfo;
  QDir theDir (qsPath);
  theDir.setFilter (QDir::Files | QDir::NoSymLinks);
  for (t=0;t<theDir.count();t++)	{
    fileInfo.setFile (qsPath + QString("/") + theDir[t]);
    iSize += fileInfo.size();
  }
  return iSize;
}

void DialogTemp::slotDelete ()
{
	QString qsLabel = m_pTabWidget->label(m_pTabWidget->currentPageIndex());
	QString qsTempPath = Global::qsTempPath + QString ("/") + qsLabel;
	int iCurrentIndex = m_pTabWidget->currentPageIndex();
	QDir theDir (qsTempPath);
	Utils theUtils;
	if (theDir.exists())	{
		if (MessageBox::warning (NULL, tr ("Warning."), tr ("Do you really want to delete\n%1").arg(qsTempPath), QMessageBox::Ok,  QMessageBox::Cancel) == QMessageBox::Ok)	{
			theUtils.recRmdir (qsTempPath, NULL);
			//int iSize = qsSize.toInt();
			unsigned long iSize = m_listSizes[iCurrentIndex];
			m_iTotalSize -= iSize;
			m_listTabs.remove (m_listTabs[iCurrentIndex]);
			m_listSizes.remove(iSize);
			delete m_pTabWidget->currentPage();
			// Okay nearly done, but we sould also update the labels to reflect reality.
			updateLabels ();
		}
	}
}

void DialogTemp::updateLabels ()
{
	int t;
	QString qsSize = formatSize (m_iTotalSize);
	m_pLabelGeneral->setText( tr( "<p align=\"center\">Found<b> %1 </b>projects : Total = <b>%2</b></p>" ).arg(m_listTabs.count()).arg(qsSize));
	for (t=0;t<(int)m_listTabs.count();t++)	{
		qsSize = formatSize (m_listSizes[t]);
		m_listTabs[t]->m_pLabelSize->setText (tr("<font size=\"-1\"><b>%1</b></font>").arg(qsSize));
	}
}

QString DialogTemp::formatSize ( unsigned long iSize )
{
	QString qsSize;
	if (iSize < 1)
		qsSize = QString ("? B");
	if (iSize < 1024)
		qsSize = QString ("%1 B").arg(iSize);
	else if (iSize < 1024*1024)
		qsSize = QString ("%1kB").arg((double)iSize/1024, 0, 'g', 3);
	else if (iSize < 1024*1024*1024)
		qsSize = QString ("%1MB").arg((double)iSize/(1024*1024), 0, 'g', 3);
	else
		qsSize = QString ("%1GB").arg((double)iSize/(1024*1024*1024), 0, 'g', 3);
	return qsSize;
}

