/****************************************************************************
** StructureToolBar - class
**
** Created: Tue May 08 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will create a toolbar, which holds only one widget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/
#include <qmainwindow.h>
#include <qmessagebox.h>
#include <qcolordialog.h>
#include <qtooltip.h>

#include "global.h"
#include "colortoolbar.h"
#include "dvdmenu.h"

QColorFrame::QColorFrame (int iWhichColor, QColor theColor, QWidget *pParent, const char *pName, WFlags f)
	: QFrame (pParent, pName, f)
{
	m_iWhichColor = iWhichColor;
	setPaletteBackgroundColor (theColor);
	setFixedSize( QSize( 30, 30 ) );
	setFrameShape( QFrame::GroupBoxPanel );
	setFrameShadow( QFrame::Raised );
	setLineWidth( 3 );
}

void QColorFrame::mouseReleaseEvent (QMouseEvent *pMouseEvent)
{
	QFrame::mouseReleaseEvent(pMouseEvent);
//	if (pMouseEvent->button() == RightButton)
	emit (signalRightButtonClicked (m_iWhichColor));
}

QColor QColorFrame::getColor()
{
	return paletteBackgroundColor();
}

void QColorFrame::setColor(QColor newColor)
{
	setPaletteBackgroundColor(newColor);
}


ColorToolBar::ColorToolBar (const QString &qsLabel, QMainWindow *pMainWindow, QWidget *pParent, bool bNewLine, const char *pName, WFlags f)
	: QToolBar (qsLabel, pMainWindow, pParent, bNewLine, pName, f)
{
	m_pCurrentDVDMenu = NULL;
	setResizeEnabled (false);
	setMovingEnabled (true);
	pMainWindow->addDockWindow (this, Top);

	// Next we include the 4 colors (MAX_MASK_COLORS) for the Button masks into the main toolbar.
	m_colorFrames[0] = new QColorFrame (0, QColor (TRANSPARENT_COLOR), this);
	m_colorFrames[1] = new QColorFrame (1, QColor (START_HIGHLIGHTED_COLOR), this);
	m_colorFrames[2] = new QColorFrame (2, QColor (START_SELECTED_COLOR), this);
	m_colorFrames[3] = new QColorFrame (3, QColor (START_FRAME_COLOR), this);

	QToolTip::add( m_colorFrames[0], "Change DVD mask colors\nFor button masks." );
	QToolTip::add( m_colorFrames[1], "Change DVD mask colors\nFor button masks." );
	QToolTip::add( m_colorFrames[2], "Change DVD mask colors\nFor button masks." );
	QToolTip::add( m_colorFrames[3], "Change DVD mask colors\nFor button masks." );

	connect (m_colorFrames[0], SIGNAL(signalRightButtonClicked (int)), this, SLOT(slotColorClicked(int)));
	connect (m_colorFrames[1], SIGNAL(signalRightButtonClicked (int)), this, SLOT(slotColorClicked(int)));
	connect (m_colorFrames[2], SIGNAL(signalRightButtonClicked (int)), this, SLOT(slotColorClicked(int)));
	connect (m_colorFrames[3], SIGNAL(signalRightButtonClicked (int)), this, SLOT(slotColorClicked(int)));
}

ColorToolBar::~ColorToolBar ()
{

}

void ColorToolBar::slotColorClicked(int iColor)
{
  while (iColor > MAX_MASK_COLORS-1)
    iColor -= MAX_MASK_COLORS;
  QColorDialog::setCustomColor(0, m_colorFrames[0]->getColor().rgb());
  QColorDialog::setCustomColor(1, m_colorFrames[1]->getColor().rgb());
  QColorDialog::setCustomColor(2, m_colorFrames[2]->getColor().rgb());
  QColorDialog::setCustomColor(3, m_colorFrames[3]->getColor().rgb());
  QColor theColor = QColorDialog::getColor(m_colorFrames[iColor]->getColor());
  if ( ! theColor.isValid() )
    return;
  m_colorFrames[iColor]->setColor(theColor);
  
  // And here we set the color in the Menu accordingly
  if (m_pCurrentDVDMenu)
    m_pCurrentDVDMenu->modifyColor((uint)iColor, theColor);
}

QColor ColorToolBar::getColor(uint iWhichColor)
{
	return m_colorFrames[iWhichColor]->getColor();
}

void ColorToolBar::setColor(uint iWhichColor, QColor theColor)
{
  if (iWhichColor < MAX_MASK_COLORS)
    m_colorFrames[iWhichColor]->setColor(theColor);
}

void ColorToolBar::setDVDMenu(DVDMenu *pMenu)
{
	uint t;
	CDVDMenuInterface *pInterface = NULL;
	if (pMenu)	{
		pInterface = pMenu->getInterface();
		for (t=0;t<MAX_MASK_COLORS;t++)
			setColor(t, pInterface->pgcColors[t]);
	}
	m_pCurrentDVDMenu = pMenu;
}

/*
void ColorToolBar::modifyColor(QColor theColor, uint iWhichColor, void *pMenu)
{
	// This function changes the colors according to the following rules :
	// tHERE ARE 4 colors available :
	// -	1 = Transparent color
	// -	2 = Highlighted color
	// -	3 = Selected color
	// -	4 = -=> FREE <=-
	
	// 1)	The first color change is associated to the 4'th color
	// 2)	The second color change will affect all Buttons (Selected or Highlighted)
	//		a)	If only one ButtonObject in menu, then don't care
	//		b)	Else ask user to confirm
	//			- inquire which color ...
	//			- Go through all ButtonObjects of this menu and change this color
	//		c)	Change ColorToolbar ...
	static bool bFirstModification = true;
	if (bFirstModification)	{
		m_colorFrames[MAX_MASK_COLORS]->setColor(theColor);
		bFirstModification = false;
	}

	// The pointer pMenu is also abused to indicate if we should force the color change 
	// This is done when we have only one ButtonObject currently ...
	if (pMenu)	{
		QString qsWhichColor ("Highlighted");
		if (iWhichColor == SELECTED_MASK)
			qsWhichColor = QString ("Selected");

		if (QMessageBox::information ( this, tr("Change all colors ?"), tr("This modification will change will affect all %1 colors.\n"
			"Do you want to proceed ?").arg(qsWhichColor), QMessageBox::Yes, QMessageBox::No ) == QMessageBox::No)
			return;
	}

	m_colorFrames[iWhichColor]->setColor(theColor);
	emit (signalChangeMaskColor (theColor, iWhichColor));
}
*/
