/*****************************************************************************
 ** Class PluginInterface
 **
 ** Interface class for plugins.
 **
 ** At this point in time the interface is preliminary and bound to change.
 ** Also note that currently we do not dynamically load the Plugin.
 ** 2007 Feb 09
 **
 *****************************************************************************/

#ifndef __PLUGIN_INTERFACE_H__
#define __PLUGIN_INTERFACE_H__

#include <qobject.h>

namespace Plugin
{


class Interface : public QObject
{
  Q_OBJECT

public:
  enum enResponseType { 
    Undef=0,
    NTSCMenuResponse,
    PALMenuResponse
  };

           Interface  ( ) { };
  virtual ~Interface  ( ) { };

  virtual void  initMe  ( QObject * ) { };
  virtual float version ( ) = 0;

  // The following signal defines the callback values
signals:
  void signalPluginResponse ( int, QString, QString );

};

}

#endif // __PLUGIN_INTERFACE_H__
