/****************************************************************************
** DialogMPlayerSetup class
**
** Created: Fri Dec 14 22:48:00 2004
**      by: Varol Okan using Kate
**
****************************************************************************/
#ifdef QDVD_LINUX 
#include <unistd.h>
#endif 

#include <qregexp.h>
#include <qprocess.h>
#include <qcombobox.h>
#include <qlineedit.h>

#include "../../win32.h"
#include "qmplayerwidget.h"
#include "dialogmplayersetup.h"

DialogMPlayerSetup::DialogMPlayerSetup(QWidget * parent, const char * name, WFlags f)
	: uiDialogMPlayerSetup (parent, name, f)
{
	m_pVideoProcess  = NULL;
	m_pAudioProcess  = NULL;
	m_pListPluginOptions = NULL;
}

DialogMPlayerSetup::~DialogMPlayerSetup ()
{

}

void DialogMPlayerSetup::killProcesses ()
{
	if (m_pVideoProcess)	{
		m_pVideoProcess->kill();
		delete m_pVideoProcess;
	}
	if (m_pAudioProcess)	{
		m_pAudioProcess->kill();
		delete m_pAudioProcess;
	}
	m_pVideoProcess = NULL;
	m_pAudioProcess = NULL;
}

void DialogMPlayerSetup::initMe (QStringList *pListPluginOptions)
{
	QStringList listCommand;
	killProcesses ();

	m_pListPluginOptions = pListPluginOptions;
	// Here we set the current Plugin Options
	m_pEditVideoOptions->setText ((*pListPluginOptions)[QMPlayerWidget::VideoPluginOptions]);
	m_pEditAudioOptions->setText ((*pListPluginOptions)[QMPlayerWidget::AudioPluginOptions]);
	// And also update the GUI (Note: the driver is set when we have the values in)
	
	// Video plugin request ...
	m_pVideoProcess = new QProcess;
	// Request VidoePlugin information
	listCommand.append(QString("mplayer"));
	listCommand.append(QString("-vo"));
	listCommand.append(QString("help"));
	connect (m_pVideoProcess, SIGNAL(readyReadStdout()), this, SLOT (slotProcessVideoPlugins ()));
	m_pVideoProcess->setArguments (listCommand);

	// Audio plugin request ...
	m_pAudioProcess = new QProcess;
	listCommand.clear ();
	// Request VidoePlugin information
	listCommand.append(QString("mplayer"));
	listCommand.append(QString("-ao"));
	listCommand.append(QString("help"));
	connect (m_pAudioProcess, SIGNAL(readyReadStdout()), this, SLOT (slotProcessAudioPlugins ()));
	m_pAudioProcess->setArguments (listCommand);

	m_pVideoProcess->start();
	m_pAudioProcess->start();
}

void DialogMPlayerSetup::slotProcessVideoPlugins ()
{
//printf ("DialogMPlayerSetup::slotProcessVideoPlugins \n");
	uint t;
	QStringList listInfos;
	QString qsCurrent;
	QString qsStdout(m_pVideoProcess->readStdout());
	// The length will tell us if we have the requested information or not.
	if (qsStdout.length() < 100)
		return;
//printf ("%s\n\n", (const char *)qsStdout);
	// Note withot this sleep the driver do not always show up ...
    usleep ( 10000 ); // 10 ms
	qsCurrent = (*m_pListPluginOptions)[QMPlayerWidget::VideoPlugin];
	// First we generate a list with one entry per line.
	listInfos = QStringList::split ("\n", qsStdout);

	QRegExp	regExp ("^\\s+(\\w+)\\s+.*");
	for (t=0;t<listInfos.count();t++)	{
		if (regExp.search(listInfos[t]) > -1)	{
			m_pComboVideo->insertItem (regExp.cap(1));
//printf ("<%d><%s> -=> <%s>\n", t, (const char *)listInfos[t], (const char *)regExp.cap(1));
			if ( (!qsCurrent.isNull()) && (qsCurrent == regExp.cap(1)) )
				m_pComboVideo->setCurrentText (qsCurrent);
		}
	}
}

void DialogMPlayerSetup::slotProcessAudioPlugins ()
{
	uint t;
	QStringList listInfos;
	QString qsCurrent;
	QString qsStdout(m_pAudioProcess->readStdout());
	// The length will tell us if we have the requested information or not.
	if (qsStdout.length() < 100)
		return;
	// Note without this sleep the driver do not always show up ...
    usleep ( 10000 ); // 10ms
	qsCurrent = (*m_pListPluginOptions)[QMPlayerWidget::AudioPlugin];
	// First we generate a list with one entry per line.
	listInfos = QStringList::split ("\n", qsStdout);

//printf ( "Audio found %d plugins\n", (int)listInfos.count ( ) );

	QRegExp	regExp ("^\\s+(\\w+)\\s+.*");
	for (t=0;t<listInfos.count();t++)	{
//		printf ( "Audio [%d] = <%s>\n", t, listInfos[t].ascii() );
		if (regExp.search(listInfos[t]) > -1)	{
//printf ( "  Insert [%d]<%s>\n", t, regExp.cap ( 1 ).ascii ( ) );
			m_pComboAudio->insertItem (regExp.cap(1));
			if ( (!qsCurrent.isNull()) && (qsCurrent == regExp.cap(1)) )
				m_pComboAudio->setCurrentText (qsCurrent);
		}
	}
}

