###################################################
##                                               ##
##            'Q'Render project file             ##
##                                               ##
##             Created using Kate by             ##
##                                               ##
##                   Varol Okan                  ##
##                                               ##
##                  December 2008                ##
##                                               ##
###################################################

WHICH_PREFIX     = $$(PREFIX)
WHICH_FFMPEG     = $$(FFMPEG)
WHICH_FFMPEG_INC = $$(FFMPEG_INC)
WHICH_FFMPEG_LIB = $$(FFMPEG_LIB)
STATIC_FFMPEG    = $$(STATIC_FFMPEG)

isEmpty (WHICH_FFMPEG)  {
  exists ( ffmpeg/ )  {
    WHICH_FFMPEG=$$(PWD)/ffmpeg
  }
  else  {
    WHICH_FFMPEG=$$system(pkg-config --variable=prefix libavformat)
  }
  isEmpty (WHICH_FFMPEG)  {
    WHICH_FFMPEG=/usr/local
  }
}
isEmpty (WHICH_FFMPEG_INC)  {
  exists ( ffmpeg/include/ )  {
    WHICH_FFMPEG_INC=$$(PWD)/ffmpeg/include
  }
  else  {
    WHICH_FFMPEG_INC=$$system(pkg-config --variable=includedir libavformat)
  }
  isEmpty (WHICH_FFMPEG_INC)  {
    WHICH_FFMPEG_INC=$${WHICH_FFMPEG}/include
  }
}
isEmpty (WHICH_FFMPEG_LIB)  {
  exists ( ffmpeg/lib/ )  {
    WHICH_FFMPEG_LIB=$$(PWD)/ffmpeg/lib
  }
  else  {
    WHICH_FFMPEG_LIB=$$system(pkg-config --variable=libdir libavformat)
  }
  isEmpty (WHICH_FFMPEG_LIB)  {
    WHICH_FFMPEG_LIB=$${WHICH_FFMPEG}/lib
  }
}

# First check is for qmake version.
! contains ( QT_MAJOR_VERSION, "4" )  {
  error ( "qmake version $${QT_VERSION} to old. Please use qt 4.x" )
}

system  ( echo )
message ( Qt version: $$[QT_VERSION] )
message ( Qt is installed in $$[QT_INSTALL_PREFIX] )
message ( Using ffmpeg lib from : $$WHICH_FFMPEG )

defineReplace(findLib2)  {
  lib = $$1
  libFound = $$system(/sbin/ldconfig -p | sort | grep 64 | grep -m 1 lib$${lib}.so$ | awk \'{print $4}\')
  isEmpty ( libFound )  {
    libFound = $$system(/sbin/ldconfig -p | sort | grep 64 | grep -m 1 lib$${lib}.so | awk \'{print $4}\')
  }
  isEmpty ( libFound )  {
    libFound = $$system(/sbin/ldconfig -p | sort | grep -m 1 lib$${lib}.so$ | awk \'{print $4}\')
  }
  isEmpty ( libFound )  {
    libFound = $$system(/sbin/ldconfig -p | sort | grep -m 1 lib$${lib}.so | awk \'{print $4}\')
  }
  return ($$libFound)
}

defineReplace(findLib)  {
  lib = $$1
  system(/sbin/ldconfig -p | grep -m 1 lib$${lib}.so | awk \'{print $4}\' | sort > /tmp/ab)
  libFound = $$system(cat /tmp/ab | grep -m 1 64)
  isEmpty ( libFound )  {
    libFound = $$system(cat /tmp/ab | grep -m 1 lib)
  }
  return ($$libFound)
}

bz2       = $$findLib( bz2       )
theora    = $$findLib( theora    )
vorbisenc = $$findLib( vorbisenc )
message ( BZ2 = $$bz2 )
message ( Theora = $$theora )
message ( VorbisEnc = $$vorbisenc )

unix {
  UI_DIR       = .ui
  MOC_DIR      = .moc
  OBJECTS_DIR  = .obj
}
win32 {
  UI_DIR       = ui
  MOC_DIR      = moc
  OBJECTS_DIR  = obj
}

HEADERS       = utils.h\
		shared.h\
		server.h \
                render.h  \
		parser.h   \
		logger.h    \
		filter.h     \
		slideshow.h   \
		encoder.h      \
		engine/ffmpeg_enc.h \
		../qdvdauthor/xml_slideshow.h

SOURCES       = main.cpp \
		utils.cpp \
		server.cpp \
                render.cpp  \
		parser.cpp   \
		logger.cpp    \
		filter.cpp     \
		slideshow.cpp   \
		encoder.cpp      \
		engine/ffmpeg_enc.cpp \
		../qdvdauthor/xml_slideshow.cpp

WHICH_PREFIX = $$(PREFIX)
isEmpty(WHICH_PREFIX) {
        WHICH_PREFIX =/usr
}


# Next we try to find the where abouts of the ffmpeg library
! isEmpty ( STATIC_FFMPEG )  {
  exists  ( $${WHICH_FFMPEG_LIB}/libavcodec.a ) {
    LIBS += $${WHICH_FFMPEG_LIB}/libavformat.a $${WHICH_FFMPEG_LIB}/libavcodec.a $${WHICH_FFMPEG_LIB}/libavutil.a $${WHICH_FFMPEG_LIB}/libavdevice.a $${WHICH_FFMPEG_LIB}/libswscale.a
    message ( Using static ffmpeg library )
  }
  else  {
    LIBS += -lavformat -lavcodec -lavutil -lavdevice -lswscale
    message ( Using shared ffmpeg libary )
    message ( ..for static ffmpeg : > export STATIC_FFMPEG=1; qmake )
  }
}
else  {
  LIBS += -lavformat -lavcodec -lavutil -lavdevice -lswscale
  message ( Using shared ffmpeg libary )
  message ( ..for static ffmpeg : > export STATIC_FFMPEG=1; qmake )
}
system ( echo )
# remove theora, and vorbisenc if not installed
# Note for SuSE: libtheora.so has to be created through 
# > cd /usr/lib && ln -s libtheora.so.0 libtheora.so
#LIBS      += -L$${WHICH_FFMPEG_LIB} -ltheora -lvorbisenc -lbz2
LIBS   += -L$${WHICH_FFMPEG_LIB} 
! isEmpty ( theora )  {
  LIBS += $${theora}
}
! isEmpty ( vorbisenc )  {
  LIBS += $${vorbisenc}
}
! isEmpty ( bz2 )  {
  LIBS += $${bz2}
}

target.path  = $${WHICH_PREFIX}/bin

INCLUDEPATH += $${WHICH_FFMPEG_INC}
TEMPLATE     = app
INSTALLS    += target
DESTDIR      = ../bin
DEFINES     += QDVD_RENDER
CONFIG      += debug
QMAKE_CXXFLAGS_DEBUG += -O0 -ggdb3
QMAKE_CFLAGS_DEBUG   += -O0 -ggdb3
QT          += xml network


