/*****************************************************************************
 ** Class QSubtitles
 **
 ** This class displays the DVD Layout - tab of the main QDVDAuthor
 ** application
 **
 **   Created : March 22 2009
 **        by : Varol Okan
 ** Copyright : (c) Varol Okan
 ** License   : GPL v 2.0
 **
 *****************************************************************************
 ** The DVD Layout must handle
 ** o DVDMenuObjects
 ** o MovieObjects
 ** o FirstObject ( FPC )
 ** o PreObjects / PostObjects
 *****************************************************************************/

#ifndef DVDLAYOUTGUI_H
#define DVDLAYOUTGUI_H

#include <qlabel.h>
#include <qimage.h>

#include "uidvdlayout.h"

class DVDMenu;
class SourceFileEntry;
class QDomNode;
class QDomElement;

namespace DVDLayout
{

// Forward declaration of classes.
class Object;
class Area;

// Header used for the MenuObject, and MovieObject
class Header : public QLabel
{
  Q_OBJECT

public:
  Header ( QWidget *, Object *, const char *p=0, WFlags f=0 );
  virtual ~Header ( );

  void displayText ( bool );
  void setText     ( const QString & );

signals:
  void signalRedrawAll ( );

protected:
  virtual void mouseMoveEvent        ( QMouseEvent * );
  virtual void mousePressEvent       ( QMouseEvent * );
  virtual void mouseReleaseEvent     ( QMouseEvent * );
  virtual void mouseDoubleClickEvent ( QMouseEvent * );

private:
  Object *m_pObject;
  QString m_qsText;
  QPoint  m_pointInitial;
  bool    m_bMousePressed;
};

// Base class or Objects in the DVD Layout tab
class Object : public QFrame
{
  Q_OBJECT

public:
  static const int BUTTON_SIZE;
  static const int INITIAL_SIZE;

public:
  typedef enum { TYPE_UNKNOWN=0, TYPE_MENU, TYPE_MOVIE } enType;

  Object ( QWidget *, const char *p=0, WFlags f=0 );
  virtual ~Object ( );

  void    setThumbnail  ( ); // Scales depending on the zoomed factor
  void    setZoom (   float  );
  void    setSize ( int, int );
  QSize   size    ( );

  virtual enType  type          ( );
  virtual void    refresh       ( ) = 0;
  virtual void   *getObject     ( ) = 0; // DVDMenu, or SourceFileEntry
  virtual QString getObjectName ( ) = 0;
  virtual void    createThumb   ( ) = 0; // Creates from DVDMenu

  void  setActiveObject   ( Object * );
  void  moveActiveObject  ( );

signals:
  void signalRedrawAll ( );

protected:
  virtual void mouseMoveEvent    ( QMouseEvent * );
  virtual void mousePressEvent   ( QMouseEvent * );
  virtual void mouseReleaseEvent ( QMouseEvent * );

protected slots:
  virtual void slotInfo      ( );
  virtual void slotRedrawAll ( );

// Private functions
private:
  void resizeHeader  ( );

// Private member variables
protected:
  Area  *m_pArea;
  QImage m_thumbnail;
  QSize  m_gridSize;
  QSize  m_objectSize;
  QPoint m_ptPosition;
  double m_fZoom;
  bool   m_bGridActivated;

  // To handle mouse click/move
  QPoint  m_pointInitial;
  bool    m_bMousePressed;

  // These are the widget that make out the PluginFunction appearance
  Header      *m_pHeader;
  QPushButton *m_pButtonInfo;
  QLabel      *m_pInsideWidget;
  QFrame      *m_pInnerFrame;
  QHBoxLayout *m_pMainLayout;

  QGridLayout *m_pFrameLayout;
  QHBoxLayout *m_pHeaderLayout;
};

// Main container to depict a movie
class MovieObject : public Object
{
  Q_OBJECT

public:
  MovieObject ( QWidget *, SourceFileEntry * );
  virtual ~MovieObject ( );

  virtual enType  type          ( );
  virtual void    refresh       ( );
  virtual void   *getObject     ( ); // DVDMenu, or SourceFileEntry
  virtual QString getObjectName ( );
  virtual void    createThumb   ( ); // Creates from SourceFileEntry

  QImage drawMovieLines( QImage & );

private:
  SourceFileEntry *m_pSourceFileEntry;
};

// Main container to depict a DVD Menu
class MenuObject : public Object
{
  Q_OBJECT

public:
  MenuObject ( QWidget *, DVDMenu * );
  virtual ~MenuObject ( );

  virtual enType  type          ( );
  virtual void    refresh       ( );
  virtual void   *getObject     ( ); // DVDMenu, or SourceFileEntry
  virtual QString getObjectName ( );

  virtual void createThumb  ( ); // Creates from DVDMenu

private:
public:
  DVDMenu *m_pDVDMenu;
};

class Gui : public uiDVDLayout
{
  Q_OBJECT

  static const int REFRESH_MENU;

public:
   Gui ( QWidget *, const char *p=0, WFlags f=0 );
  ~Gui ( );

  void refresh ( );
  void clear   ( );

  void refreshMenus ( );

  bool readProjectFile  ( QDomNode    & );
  bool writeProjectFile ( QDomElement & );

protected:
  Object *findObject  ( void *, bool );
  Object *findObject  ( void * );
  Object *checkEntry  ( SourceFileEntry * );
  void    createEntry ( SourceFileEntry * );
  Object *checkMenu   ( DVDMenu * );
  void    createMenu  ( DVDMenu * );

protected slots:
  virtual void slotRecreateThumb ( );
  virtual void slotPostRead      ( );
  virtual void slotPan           ( );
  virtual void slotGrid          ( );
  virtual void slotPrinter       ( );
  virtual void slotRefresh       ( );
  virtual void slotAdjustZoom    ( );
  virtual void slotZoomChanged   ( );
  virtual void slotZoomChanged   ( int );
  virtual void slotSliderMoved   ( int );
  virtual void slotRouterChanged ( int );

// Private functions
private:
  void   refresh    ( bool  );
  void   setZoom    ( float );
  QPoint initialPos ( bool  );

private:
  Area *m_pArea;
  int   m_iPreviousSliderValue;
  QValueList<Object *> m_listOfObjects;
  QValueList<Object *> m_listOfMenus;
  QValueList<Object *> m_listOfVideos;

  QValueList<Object *> m_listRecreateThumbs;
};

}; // End of namespace DVDLayout

#endif // DVDLAYOUTGUI_H
