/****************************************************************************
** StructureToolBar - class
**
**   Created : Tue May 04 12:09:08 2004
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class will create a toolbar, which holds only one widget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/
#include <qmainwindow.h>
#include <qdockarea.h>
#include <qlistview.h>

#include "dvdmenu.h"
#include "menupreview.h"
#include "menuobject.h"
#include "structuretoolbar.h"

StructureItem::~StructureItem ( )
{
  //printf ( "    StructureItem : DELETE  <%p> <%s>\n", this, text ( 0 ).ascii ( ) );
  initMe ( );
}

void StructureItem::initMe ( )
{
  //  printf ( "    StructureItem : CREATE  <%p> <%s>\n", this, text( 0 ).ascii ( ) );
  m_pDVDMenu     = NULL; 
  m_pMenuPreview = NULL; 
  m_pMenuObject  = NULL; 
}

StructureItem *StructureItem::setSibling ( MenuObject *pMenuObject, StructureItem *pItem, QString qsName, QString qsArgs )
{
  StructureItem *pSibling = NULL;
  int a=0, b=0;

  if ( pItem ) {
    a = 1;
    pSibling = (StructureItem *)pItem->nextSibling ( );
  }
  else {
    a = 2;
    pSibling = (StructureItem *)firstChild ( );
  }

  if ( ! pSibling ) {
    pSibling = new StructureItem ( pMenuObject, this, pItem, qsName, qsArgs );
    b = 1;
  }
  else {
    pSibling->setText ( qsName, qsArgs );
    b = 2;
  }

  //  printf ( "  StructureItem::setSibling <%p> == a=<%d> b=<%d>  <%s><%s>\n", this, a, b, qsName.ascii(), qsArgs.ascii() );
  return pSibling;
}

StructureItem *StructureItem::setSibling ( DVDMenu *pDVDMenu, StructureItem *pItem, QString qsName, QString qsArgs )
{
  StructureItem *pSibling = NULL;
  int a=0, b=0;

  if ( pItem ) {
    a = 1;
    pSibling = (StructureItem *)pItem->nextSibling ( );
  }
  else {
    a = 2;
    pSibling = (StructureItem *)firstChild ( );
  }

  if ( ! pSibling ) {
    pSibling = new StructureItem ( pDVDMenu, this, pItem, qsName, qsArgs );
    b = 1;
  }
  else {
    pSibling->setText ( qsName, qsArgs );
    b = 2;
  }

  //  printf ( "  StructureItem::setSibling <%p> == a=<%d> b=<%d>  <%s><%s>\n", this, a, b, qsName.ascii(), qsArgs.ascii() );

  return pSibling;
}

StructureItem *StructureItem::setSibling ( MenuPreview *pMenuPreview, StructureItem *pItem, QString qsName, QString qsArgs )
{
  StructureItem *pSibling = NULL;
  int a=0, b=0;

  if ( pItem ) {
    a = 1;
    pSibling = (StructureItem *)pItem->nextSibling ( );
  }
  else {
    a = 2;
    pSibling = (StructureItem *)firstChild ( );
  }

  if ( ! pSibling ) {
    pSibling = new StructureItem ( pMenuPreview, this, pItem, qsName, qsArgs );
    b = 1;
  }
  else {
    pSibling->setText ( qsName, qsArgs );
    b = 2;
  }

  //  printf ( "  StructureItem::setSibling <%p> == a=<%d> b=<%d>  <%s><%s>\n", this, a, b, qsName.ascii(), qsArgs.ascii() );
  return pSibling;
}

void StructureItem::setText ( QString &qsName, QString &qsArgs )
{
  if ( text ( 0 ) != qsName )
    setText ( 0,     qsName );
  if ( text ( 1 ) != qsArgs )
    setText ( 1,     qsArgs );
}

void StructureItem::setText ( int iColumn, QString &qsText )
{ 
  return QListViewItem::setText ( iColumn, qsText );
}

StructureItem *StructureItem::lastChild ( )
{
  StructureItem *pPrev, *pLastItem = (StructureItem *)firstChild ( );
  pPrev = pLastItem;
  while ( pLastItem ) {
    // Special handling for this item ...
    if  ( pLastItem->text ( 0 ) == QObject::tr ( "Specified Buttons" ) )
      return pPrev;
    pPrev     = pLastItem;
    pLastItem = (StructureItem *)pLastItem->nextSibling ( );
  }
  return pPrev;
}

StructureToolBar::StructureToolBar ( const char *pName, QMainWindow *pMainWindow )
  : QDockWindow ( QDockWindow::InDock, pMainWindow, pName )
{
  pMainWindow->addDockWindow ( this, DockLeft );
  m_pStructureWidget = new uiStructureWidget ( this );
  setResizeEnabled (  TRUE );
  setMovingEnabled (  TRUE );
  setNewLine       ( FALSE );
  setWidget    ( m_pStructureWidget );
  setCaption   ( pName );

  connect( m_pStructureWidget->m_pListViewStructure, SIGNAL( rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT (slotRightClickedOnStructure (QListViewItem *, const QPoint &, int)) );
  connect( m_pStructureWidget->m_pListViewTitleset , SIGNAL( rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT (slotRightClickedOnTitleset  (QListViewItem *, const QPoint &, int)) );
}

StructureToolBar::~StructureToolBar ()
{
  delete m_pStructureWidget;
}

StructureItem *StructureToolBar::clean ( bool bStructureView )
{
  StructureItem *pMainItem = NULL;
  QListView     *pListView;

  if ( bStructureView ) {
    pListView =   m_pStructureWidget->m_pListViewStructure;
    // if there is already a 'first' Item, then we return this.
    if  ( pListView->firstChild ( ) )
      return (StructureItem *)pListView->firstChild ( );
    //pListView->clear ();
    pMainItem = new StructureItem ( pListView, tr ("DVD Project") );
  }
  else {
    pListView = m_pStructureWidget->m_pListViewTitleset;
    pListView->clear ();
    pMainItem = new StructureItem ( pListView, tr ("VMGM") );
  }
  pListView->setSorting( -1, TRUE );
  pMainItem->setExpandable ( TRUE );
  pMainItem->setOpen       ( TRUE );

  return pMainItem;
}

QSize StructureToolBar::sizeHint () const
{
  QSize theSize = QDockWindow::sizeHint();
  if ( ( area ( ) != 0) && 
       ( area ( )->orientation ( ) == Qt::Vertical ) )  // it is docked, make it at least 250 wide
    theSize.setWidth ( 250 );
  return QSize ( theSize );
  //return QSize ( QDockWindow::sizeHint().width(), 200 );
  //return QSize (250, 200);
}

void StructureToolBar::slotRightClickedOnStructure (QListViewItem *pItem, const QPoint &pos, int iColumn)
{
  if ( ( ! pItem ) || (iColumn == -1) || (pItem->rtti () != 5000 ) )
    return; 
  StructureItem *pStructureItem = (StructureItem *)pItem;
  pStructureItem->createContextMenu (pos);
}

void StructureToolBar::slotRightClickedOnTitleset (QListViewItem *, const QPoint &, int)
{
  //  printf ("StructureToolBar::slotRightClickedOnTitleset\n");
}

void StructureItem::createContextMenu    ( QPoint p )
{
  QString qsText  = text ( 1 );
  bool bIntro     = false;
  bool bSoundFile = false;
  if ( text ( 0 ).find ( "Intro File" ) > -1 )
    bIntro = true;
  else if ( text ( 0 ).find ( "Sound File" ) > -1 )
    bSoundFile = true;

  if ( m_pMenuObject )
    m_pMenuObject->createContextMenu  ( p );    
  else if ( m_pMenuPreview )
    m_pMenuPreview->createContextMenu ( p );
  else if ( m_pDVDMenu ) {
    if ( bSoundFile )
      m_pDVDMenu->createSoundMenu ( p, qsText );
    else
      m_pDVDMenu->createIntroExtroMenu( p, bIntro, qsText );
  }
}

