/****************************************************************************
** Class Utils implementation ...
**
**   Created : Wed Jun 17 07:53:05 2008
**        by : Varol Okan
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** Here we have some misc functions which are needed by a few classes 
** but can not really be assigned to any of those classes.
**
****************************************************************************/

#include <QDir>

#include "utils.h"

Utils::Utils()
{

}

Utils::~Utils ()
{

}

unsigned long long Utils::SDBMHash ( QString &str )
{
   unsigned long long hash = 0;
   for ( unsigned int i = 0; i < (unsigned int)str.length ( ); i++ )
     hash = str[i].toLatin1 ( ) + (hash << 6) + (hash << 16) - hash;

   return hash;
}

bool Utils::recMkdir ( const QString &qsDir )
{
  QDir theDir ( qsDir );
  if ( theDir.exists ( ) )
    return true;

  int t;
  QString qsFullPath, qsPartialDir;
  qsFullPath = theDir.absolutePath ( );
  QStringList dirList = qsFullPath.split ( "/" );

  for ( t=0; t<(int)dirList.count ( ); t++ )  {
    qsPartialDir += "/" + dirList[t];
    theDir.setPath ( qsPartialDir );
    if ( theDir.exists ( ) )
      continue;
    if ( ! theDir.mkdir ( qsPartialDir ) )
      return false;
  }

  // Sanity check if the dir exists ...
  theDir.setPath ( qsFullPath );
  if ( ! theDir.exists ( ) )  {
    printf ( "Failed to create temp directory\n%s\nPlease make sure you have the read/write access.", (const char *)qsFullPath.toUtf8 ( ) );
    return false;
  }
  return true;
}

