/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
**
**   Created : 
**        by : Varol Okan 
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
*****************************************************************************/

#include <qpixmap.h>

#include "utils.h"
#include "global.h"
#include "qimagehelper.h"

void CResizeDialog::slotManualResize(const QString &)
{
}


void CResizeDialog::slotResize ( int iState )
{
	// Here we filter out the second RadioButton, which gets Unset ...
	if (iState != QButton::On)
		return;
	int iWidth = 720;
	int iHeight = 480;
	int iFormat = FORMAT_NONE;
	// ButtonGroup : 
	if (m_pRadio1->isChecked())	{
		iWidth	= 720;
		iHeight	= 576;
		iFormat = FORMAT_PAL1;
	}
	else if (m_pRadio2->isChecked()){
		iWidth	= 704;
		iHeight	= 576;
		iFormat = FORMAT_PAL2;
	}
	else if (m_pRadio3->isChecked()){
		iWidth	= 352;
		iHeight	= 576;
		iFormat = FORMAT_PAL3;
	}
	else if (m_pRadio4->isChecked()){
		iWidth	= 352;
		iHeight	= 288;
		iFormat = FORMAT_PAL4;
	}
	else if (m_pRadio5->isChecked()){
		iWidth	= 720;
		iHeight	= 480;
		iFormat = FORMAT_NTSC1;
	}
	else if (m_pRadio6->isChecked()){
		iWidth	= 704;
		iHeight	= 480;
		iFormat = FORMAT_NTSC2;
	}
	else if (m_pRadio7->isChecked()){
		iWidth	= 352;
		iHeight	= 480;
		iFormat = FORMAT_NTSC3;
	}
	else if (m_pRadio8->isChecked()){
		iWidth	= 352;
		iHeight	= 240;
		iFormat = FORMAT_NTSC4;
	}
	m_pEditWidth->setText(QString("%1").arg(iWidth));
	m_pEditHeight->setText(QString("%1").arg(iHeight));
	m_iFormat = iFormat;
	slotPreview();
}


void CResizeDialog::slotResizeAlogrithm( int iState )
{
	if (iState != QButton::On)
		return;

}

void CResizeDialog::slotStretchType( int iState )
{
	if (iState == QButton::On)
		slotPreview ();

	bool bEnable = false;
	if (m_pRadioStretch3->isOn())
		bEnable = true;
	m_pEditOffsetX->setEnabled(bEnable);
	m_pEditOffsetY->setEnabled(bEnable);
}

void CResizeDialog::slotPreview()
{
	QCursor myCursor (QCursor::WaitCursor);
	setCursor(myCursor);

	int iWidth, iHeight;
	bool  bOk = true;

	iWidth = m_pEditWidth->text().toInt(&bOk);
	if (!bOk)
		iWidth = 720;
	iHeight = m_pEditHeight->text().toInt(&bOk);
	if (!bOk)
		iHeight = 480;

	// And since we are using a preview, we can shrink it by factor 2.
	iWidth  = (int) (iWidth  / 2.0);
	iHeight = (int) (iHeight / 2.0);
	m_iStretchType = 0;
	if (m_pRadioStretch2->isOn())
		m_iStretchType = 1;
	else if (m_pRadioStretch3->isOn())
		m_iStretchType = 2;

	preview (iWidth, iHeight, getResizeAlgorithm());

	myCursor = QCursor(QCursor::ArrowCursor);
	setCursor(myCursor);
}

int CResizeDialog::getResizeAlgorithm ()
{
	int iResizeAlgorithm = RESIZE_QT;
	// Here we see which algol the user wants to use ...
	comboResizeAlgorithm->currentItem();
	// Please note that the QImageHelper class can figure out the algol itself since
	// the QStringList has been delivered in a known order.
	return iResizeAlgorithm;
}

void CResizeDialog::preview (int iWidgetWidth, int iWidgetHeight, int iResizeAlgorithm)
{
	QImageHelper theImage;
	bool bOk;
	int iDeltaX, iDeltaY, iOffsetX, iOffsetY;

	iOffsetX = m_pEditOffsetX->text().toInt(&bOk);
	if (!bOk)
		iOffsetX = 0;
	iOffsetY = m_pEditOffsetY->text().toInt(&bOk);
	if (!bOk)
		iOffsetY = 0;

	if (!m_qsFileName.isEmpty())
		theImage = QImageHelper(m_qsFileName, 0);
	else if (m_pImage)
		theImage = QImageHelper((const QImageHelper &)*m_pImage);
	else
		return;

	QPixmap thePreview;
	// Next we handle the resizing pending the checked RadioButton algo ...
	if (m_iStretchType > 0)	{
		QImage tempImage;
		if (m_iStretchType == 2)	{	// Cut Off
			tempImage = theImage.smoothScale (iWidgetWidth, iWidgetHeight, QImage::ScaleMax);
			iDeltaX = iOffsetX;
			iDeltaY = iOffsetY;
			m_posOffset = QSize (iOffsetX, iOffsetY);
		}
		else	{	// m_iStretchType == 1 -=> Black Borders
			tempImage = theImage.smoothScale (iWidgetWidth, iWidgetHeight, QImage::ScaleMin);
			iDeltaX = iWidgetWidth - tempImage.width();
			if (iDeltaX > 0)
				iDeltaX = (int)((float)iDeltaX / 2.0);
			iDeltaY = iWidgetHeight - tempImage.height();
			if (iDeltaY > 0)
				iDeltaY = (int)((float)iDeltaY / 2.0);
		}

		theImage.fill (0);  //Qt::black);
		theImage.resize (iWidgetWidth, iWidgetHeight, iResizeAlgorithm);
		bitBlt (&theImage, iDeltaX, iDeltaY, &tempImage, 0, 0, tempImage.width(), tempImage.height(), Qt::CopyROP);
	}
	else	// StretchToFit
		theImage.resize (iWidgetWidth, iWidgetHeight, iResizeAlgorithm);

	thePreview = QPixmap (iWidgetWidth, iWidgetHeight);
	
	thePreview.convertFromImage (theImage);
	m_pPixmapPreview->setFixedSize(iWidgetWidth, iWidgetHeight);
	m_pPixmapPreview->setPixmap ( (const QPixmap &) thePreview);
}

void CResizeDialog::slotOk(void)
{
	int iWidth, iHeight;
	bool  bOk = true;
	Utils theUtils;
	iWidth = m_pEditWidth->text().toInt(&bOk);
	if (!bOk)	{
		iWidth = 720;
		m_pEditWidth ->setText(QString ("%1").arg(iWidth));
	}
	iHeight = m_pEditHeight->text().toInt(&bOk);
	if (!bOk)	{
		iHeight = 480;
		m_pEditHeight->setText(QString ("%1").arg(iHeight));
	}
	m_iStretchType = 0;
	if (m_pRadioStretch2->isOn())
		m_iStretchType = 1;
	else if (m_pRadioStretch3->isOn())
		m_iStretchType = 2;

	m_iFormat = theUtils.getFormat ( iWidth, iHeight );
	preview(iWidth, iHeight, getResizeAlgorithm());
	accept();
}

void CResizeDialog::slotHelp()
{

}

// This function is called when there is no file associated to the image
// I.e. a Drag'n Drop operation ...
void CResizeDialog::setImage ( QImage *pImage )
{
	// first we set the avail resize algos ...
	QImageHelper temp;
	comboResizeAlgorithm->clear();
	comboResizeAlgorithm->insertStringList (temp.getAvailableResizeAlgorithms());
	m_qsFileName = QString();
	m_pImage = pImage;
	slotPreview();
}

void CResizeDialog::setSize( int iWidth, int iHeight )
{
  QString qsText;
  qsText = QString ( "%1" ).arg ( iWidth );
  m_pEditWidth->setText  ( qsText );
  qsText = QString ( "%1" ).arg ( iHeight );
  m_pEditHeight->setText ( qsText );
  }

void CResizeDialog::setFilename( QString &qsFileName )
{
	// first we set the avail resize algos ...
	QImageHelper temp;
	comboResizeAlgorithm->clear();
	comboResizeAlgorithm->insertStringList (temp.getAvailableResizeAlgorithms());
	m_qsFileName = qsFileName;
	m_pImage = NULL;
	m_pEditOffsetX->setText (QString("%1").arg(m_posOffset.width ()));
	m_pEditOffsetY->setText (QString("%1").arg(m_posOffset.height()));
	if (m_iStretchType == 0)
		m_pRadioStretch1->setChecked (true);
	else if  (m_iStretchType == 1)
		m_pRadioStretch2->setChecked (true);
	else if  (m_iStretchType == 2)
		m_pRadioStretch3->setChecked (true);
	slotPreview();
}

void CResizeDialog::setResizeAlgo( QStringList &algoList )
{
	comboResizeAlgorithm->insertStringList (algoList);
}

