#! /usr/bin/perl
#
# This file is part of qVamps.
#
# qVamps is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# qVamps is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with qVamps; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


use strict;
use warnings;


my $tr;
my $pkg = shift;


while (<>)
{
  my $found = 0;

  while (/\Wtr(Utf8)?\s*\(\s*(\".*?[^\\]\")\s*\)/g)
  {
    print "${pkg}::\n{\n" unless ($tr);
    $tr = 1;

    print "  tr ($2)\n";
    $found = 1;
  }

  next if ($found);

  if (/\#\$translate/)
  {
    my @strings = /\".*?[^\\]\"/g;

    print "${pkg}::\n{\n" unless ($tr);
    $tr = 1;

    foreach my $s (@strings)
    {
      print "  tr ($s)\n";
    }

    next;
  }
}


END
{
  print "}\n" if ($tr);
}
