/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.cliparams;

import amazon.fws.clicommando.config.OptionConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.cliparams.CliParamProcessor;
import amazon.fws.clicommando.util.StringUtils;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class MultipleCliParamProcessor
extends CliParamProcessor {
    public MultipleCliParamProcessor(ParamConfig paramConfig, String[] commandLineArgs) {
        super(paramConfig, commandLineArgs);
    }

    public void loadOptions(Options options) throws CliCommandoException {
        this.validateOptions(this.paramConfig.getOptions());
        OptionConfig optionConfig = this.paramConfig.getFirstOption();
        char valueSeparator = this.getValueSeparator(optionConfig);
        OptionBuilder.withLongOpt((String)optionConfig.getLongOpt());
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withValueSeparator((char)valueSeparator);
        options.addOption(OptionBuilder.create((String)optionConfig.getShortOpt()));
    }

    public void loadValuesFromCommandLine(CommandLine line) throws CliCommandoException {
        this.paramConfig.setValues(this.getOptionValues(line));
    }

    private char getValueSeparator(OptionConfig optionConfig) {
        String valueSeparator = optionConfig.getValueSeparator();
        if (StringUtils.isEmpty(valueSeparator)) {
            return ' ';
        }
        if (valueSeparator.length() > 1) {
            throw new BadInputException(ErrorMessages.ErrorCode.SEPARATOR_MUST_BE_SINGLE_CHARACTER, valueSeparator);
        }
        return valueSeparator.charAt(0);
    }

    protected String[] getOptionValues(CommandLine line) {
        String valueQuoteChar = this.paramConfig.getFirstOption().getValueQuoteChar();
        String keyValueSeparator = this.paramConfig.getFirstOption().getKeyValueSeparator();
        String mapEntrySeparator = this.paramConfig.getFirstOption().getMapEntrySeparator();
        String specifiedOptionName = this.getUsedOptionName(line, this.paramConfig.getFirstOption());
        String[] paramValues = null;
        if (specifiedOptionName != null) {
            paramValues = StringUtils.removeEmptyEntries(line.getOptionValues(specifiedOptionName));
        }
        if (valueQuoteChar != null && paramValues != null) {
            ArrayList<String> fixed = new ArrayList<String>();
            for (int i = 0; i < paramValues.length; ++i) {
                String paramValue = paramValues[i];
                int quoteCharIndex = paramValue.indexOf(valueQuoteChar);
                if (paramValue.contains(keyValueSeparator + valueQuoteChar) && paramValue.indexOf(keyValueSeparator) + 1 == quoteCharIndex) {
                    StringBuilder sb = new StringBuilder();
                    for (int j = i; j < paramValues.length; ++j) {
                        sb.append(paramValues[j]);
                        sb.append(' ');
                        if (paramValues[j].endsWith(valueQuoteChar + mapEntrySeparator) || paramValues[j].endsWith(valueQuoteChar)) break;
                        ++i;
                    }
                    sb.deleteCharAt(quoteCharIndex);
                    sb.deleteCharAt(sb.lastIndexOf(valueQuoteChar));
                    sb.deleteCharAt(sb.length() - 1);
                    fixed.add(sb.toString());
                    continue;
                }
                fixed.add(paramValue);
            }
            paramValues = fixed.toArray(new String[fixed.size()]);
        }
        return paramValues;
    }
}

