/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service.aws;

import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.soap.SoapSigner;
import amazon.fws.clicommando.util.ExceptionUtils;
import java.util.Vector;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.w3c.dom.Document;

public class AwsSoapSigner
implements SoapSigner {
    public void sign(Document document, Crypto crypto, String soapVersion) {
        try {
            WSSecHeader header = new WSSecHeader("", false);
            WSSecSignature signer = new WSSecSignature();
            header.insertSecurityHeader(document);
            signer.setKeyIdentifierType(1);
            signer.setSigCanonicalization("http://www.w3.org/2001/10/xml-exc-c14n#");
            signer.prepare(document, crypto, header);
            WSSecTimestamp ts = new WSSecTimestamp();
            ts.setTimeToLive(300);
            ts.prepare(document);
            ts.prependToHeader(header);
            signer.appendBSTElementToHeader(header);
            signer.appendToHeader(header);
            Vector<WSEncryptionPart> v = new Vector<WSEncryptionPart>();
            v.add(new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Content"));
            v.add(new WSEncryptionPart(AwsSoapSigner.bodyQname(soapVersion), AwsSoapSigner.envelopeUri(soapVersion), "Content"));
            signer.addReferencesToSign(v, header);
            signer.computeSignature();
        }
        catch (WSSecurityException e) {
            throw (CliCommandoException)ExceptionUtils.getRootCause((Exception)((Object)e), new BadInputException(ErrorMessages.ErrorCode.BAD_CREDENTIALS_CANNOT_SIGN, e.getMessage()));
        }
    }

    private static String bodyQname(String version) {
        return AwsSoapSigner.soapVersion(version).getBodyQName().getLocalPart();
    }

    private static String envelopeUri(String version) {
        return AwsSoapSigner.soapVersion(version).getEnvelopeURI();
    }

    private static SOAPConstants soapVersion(String soapVersion) {
        return soapVersion.equalsIgnoreCase("1.2") ? SOAPConstants.SOAP12_CONSTANTS : SOAPConstants.SOAP11_CONSTANTS;
    }
}

