getColorSchemes <-
function(.gobi = NULL)  
{
 .GGobiCall("getColorSchemes", .gobi = .gobi)
}  


addColorScheme <-
function(scheme, name, overwrite = FALSE, set = FALSE, .gobi = NULL)  
{
    # compute the type based on the class.
  type <- as.integer(0)
  ans <- .GGobiCall("addColorScheme",
                    scheme$colors, scheme$background,
                    scheme$annotations, type,
                    as.character(name),
                    as.logical(overwrite), .gobi = .gobi)

  if(set)
    setActiveColorScheme(name, .gobi = .gobi)

  ans
}  

setActiveColorScheme <-
function(id, .gobi = NULL)
{
  if(is.numeric(id))
    id <- as.integer(id)
  
 .GGobiCall("setActiveColorScheme", id, .gobi = .gobi)
}
