"$.ggobi" <-
#
# This defines a syntax trick to allow calls of the form
#  (where g is an object of class ggobi)
#
# g$getDisplayCount() 
# g$setData(mtcars)
#
# which are really translations from
#  g$name(..)  ->  name.ggobi( ..., .gobi = g)
#
function(g, name)
{
 f <- get(paste(name,"ggobi",sep="."))

 return(function(...) { f(..., .gobi=g)} )
}


"$.ggobiDataset" <-
function(d, name)
{
 f <- get(paste(name,"ggobi",sep="."))

 return(function(...) { f(...,.data = d,  .gobi=d[["ggobi"]])} )
}



print.ggobi <-
function(x,...) {
 x <-paste("ggobi reference (", unclass(x)$id , ")", sep="")
 NextMethod("print",x)
}

print.ggobiDataset <-
function(x,...) {
 x <- paste("ggobi dataset (",
            names(x[["data"]]), ", ", unclass((unclass(x)$ggobi))[["id"]], ")", sep="")
 NextMethod("print",x,...)
}

