\name{createEdgeData.ggobi}
\alias{createEdgeData.ggobi}
\title{
 GGobi Dataset used for edges/connections
}
\description{
  This function creates an empty  GGobi dataset that can be used
  to connect points within another dataset.
  The idea is that we create this ``invisible'' dataset
  within the GGobi instance.
  We don't specify values for the edges in this call, but
  use \code{\link{setEdges.ggobi}} for this.
}
\usage{
createEdgeData.ggobi(numEdges, labels=rep("", numEdges), colors=NULL, .gobi=getDefaultGGobi())
}
\arguments{
  \item{numEdges}{the total number of edges to create}
  \item{labels}{the labels for the edges, which can be used in
    annotating the connections on a plot}
  \item{colors}{the colors to use for the edges when displaying them}
  \item{.gobi}{the GGobi instance}
}

\value{
  An object of class \code{ggobiEdgeDataset}
  which extends \code{ggobiDataset}.
}
\references{
\url{http://www.ggobi.org/RSggobi}
\url{http://www.ggobi.org}
}
\author{
Duncan Temple Lang
}
\note{
  The edge mechanism in GGobi is very powerful
  and supports a very general form of linking.
  As a result, simple uses may appear complex.
  The idea with this interface is to try to hide the complexity.
  However, you are advised to read the GGobi and RGGobi manuals
  to get a better understanding of edges and  linking.
}

\seealso{
  \code{\link{getEdges.ggobi}}
  \code{\link{setEdges.ggobi}}
  \code{\link{setDisplayEdges.ggobi}}
}

\examples{

}
\keyword{dynamic}
