\name{getNumDatasets.ggobi}
\alias{getNumDatasets.ggobi}
\title{Get the number of datasets in a ggobi instance.}
\description{
  This returns the number of datasets within a ggobi instance.
}
\usage{
getNumDatasets.ggobi(.gobi=getDefaultGGobi())
}
\arguments{
  \item{.gobi}{the ggobi instance whose number of datasets is to be queried.
    This can be an object of class \code{ggobi} or an integer identifying
   the ggobi instance by position in the current list of ggobi instances.}
}
\value{
 A single integer giving the numbe of datasets in the specified ggobi instance.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{names.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  g$setData(system.file("data", "sat.xml", package="Rggobi"))

  g$getNumDatasets()
}
\keyword{visualization}
\keyword{interactive graphics}
