\name{getSmootherFunction.ggobi}
\alias{getSmootherFunction.ggobi}
\alias{setSmootherFunction.ggobi}
\title{Get or set the R function used by ggobi to perform smoothing}
\description{
DEPRECATED and NON-FUNCTIONAL.  These functions allow the user to specify and query a function
that ggobi uses when computing the smoothed values for predicting
one variable from another.
}
\usage{
getSmootherFunction.ggobi(.gobi=getDefaultGGobi())
}
\arguments{
  \item{fun}{the function that it is to be set as the 
active smoothing function for ggobi. This should take $3$ arguments:
\code{x}, \code{y} and the span or bandwidth of the smoothing.
The first two are numeric vectors of length $n$, the number of observations
and the last is a single numeric value.}
  \item{.gobi}{the GGobi identifier, either an integer giving the
 GGobi by index or an object of class \code{ggobi}}
}
\details{
 This sets a single internal C symbol to point to this function.
If it is non-NULL, ggobi will use the value as the address of an
R function and call it.
}
\value{
}

\references{\url{http://www.ggobi.org},\url{http://www.ggobi.org/Rggobi}}
\author{Duncan Temple Lang}

\seealso{ 
\code{\link{setSmootherFunction.ggobi}}
}

\examples{
\dontrun{
 library(modreg)
 setSmootherFunction(function(x, y, w) {
                       predict(loess(y ~ x, data.frame(x=x, y = y), span = w))
                      })
 


 getSmootherFunction()
}
}
\keyword{visualization} 
\keyword{interactive graphics}  
