\name{parcoords.ggobi}
\alias{parcoords.ggobi}
\title{Creates a ggobi parallel coordinates display.}
\description{
 This creates a new display window in the specified
ggobi instance and populates it with a Parallel Coordinates
plot containing 2 or more variables.
}
\usage{
parcoords.ggobi(..., .data = 1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{\dots}{Identifiers for the variables that are to be displayed
in the parallel coordinates plot.
These can be either names of variables or 
As with all ggobi plots, the variables must be in the same 
dataset.}
  \item{.data}{the dataset in the ggobi instance in which to resolve the
variable identifiers. This can be an integer giving the position
of the dataset in the ggobi list of datasets, the name of the dataset
(as returned by \code{names.ggobi}), or preferably, 
an object of class \code{ggobiDataset}.}
  \item{.gobi}{
the identifier for the ggobi instance in which to find the
dataset and also add the newly created display.
This can be an integer identifying the  ggobi instance
by order, or an object of class \code{ggobi} returned
from either \code{\link{ggobi}} or \code{\link{getGGobi}}.
}
}
\value{
An object of class \code{ggobiDisplay}.
This is an opaque type whose contents are
to be interpreted by C code and other S functions
only.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{scatmat.ggobi}}
\code{\link{scatterplot.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  g$parcoords(colnames(g[1]), .data=g[1])

   #
  g$parcoords("tars1", "tars2")
}
\keyword{visualization}
\keyword{interactive graphics}
