\name{plotLayout}
\alias{plotLayout}
\alias{gtkCells}
\title{Creates and arranges individual plots in a flexible grid layout.}
\description{
 This creates ggobi plots - be they basic or composites of basic plots -
and lays them out in the cells of a grid specified by the caller.
All the plots are contained in a single window.
This gives the R user complete control of the contents of a given
display/window in a ggobi instance, providing greater flexibility
than is possible with a graphical interface.
}
\usage{
plotLayout(..., mfrow=NULL, cells=NULL, .data = 1, .gobi=getDefaultGGobi(), display=-1)
gtkCells(r, c)
}
\arguments{
  \item{\dots}{a collection plot descriptions }
  \item{mfrow}{an integer vector of length 2 specifying the number of rows and columns 
  of the grid. Note that not alll cells must be filled. }
  \item{cells}{a 4 by k matrix in which each column gives the indices of the adjacent 
cells of the plot}
  \item{.gobi}{an integer identifying the instance of the ggobi to which the
data and display  are connected.}
  \item{r}{the number of rows to use for the cell table}
  \item{c}{the number of columns to use for the cell table}
  \item{display}{an integer identifying the display to which the plots should be added.
If this is omitted, a new display (i.e. window) is created.}
  \item{.data}{the identifier (index,  name or dataset reference) of the dataset which is to be used
to resolve variable names in the specified \code{.ggobi} (if the descriptions
do not contain this information)
}
}

\value{
 The index (as an integer) of the display which was created or
 to which the plots we added.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{scatmatrixDescription}},
\code{\link{parallelCoordDescription}},
\code{\link{ashDescription}}
\code{\link{scatterplotDescription}}
}

\examples{
  plot4 <- ashDescription("tars2")
  plot5 <- scatmatrixDescription("tars1", "tars2", "head") 
  plot6 <- parallelCoordDescription("tars1", "tars2", "head")

  g <- ggobi(system.file("data","flea.xml", package="Rggobi"))
   #
  dpy <- plotLayout(plot4, plot5, mfrow=c(1,2), .gobi = g)

   #
  cl <- gtkCells(2,2)[-3,]
  cl[3,1] <- 1
  plotLayout(plot4, plot5,plot6, mfrow=c(2,2), cells=t(cl))
}
\keyword{visualization}

