\name{scatterplot.ggobi}
\alias{scatterplot.ggobi}
\title{Creates a ggobi display containing a single scatterplot}
\description{
 This adds a new display window to the specified ggobi instance
which contains a scatterplot of the two variables
}
\usage{
scatterplot.ggobi(x, y, .data=1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{x,y}{identifiers for the two variables to be displayed in the scatterplot.
These should be given by name (as returned by \code{dimnames.ggobiDataset}, etc.).
Alternatively, they can be given by index (starting at $1$).
As with all ggobi plots, the variables must be in the same dataset.
}
  \item{.data}{the identifier for the dataset within the ggobi
instance in which the \code{x} and \code{y} identifiers are to be resolved.
This can be an integer giving the index of the desired dataset (starting at $1$),
the name of the dataset (as returned by \code{\link{names.ggobiDataset}},
or, preferrably, an object of class \code{ggobiDataset}).
If the last of these is used, the \code{.ggobi} argument is not used.}
 \item{.gobi}{the identifier for the ggobi instance, either an integer
giving it by index or an object of class \code{ggobi}.}
}
\value{
 An object of class \code{ggobiDisplay}.
This is an opaque type whose contents are
to be interpreted by C code and other S functions
only.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{scatmat.ggobi}}
\code{\link{parcoords.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  g$scatterplot("tars1", "tars2", .data = g[1])

    # Add a second dataset and then create a new scatterplot.
  g$setData(system.file("data", "sat.xml", package="Rggobi"), add=T)
  g$scatterplot("SAT", "RATIO", .data = g[2])  

   # The minimalist and unreadable invocation
  scatterplot.ggobi(c(1, 2))
}
\keyword{visualization}
\keyword{interactive graphics}
