\name{setRowNames.ggobi}

\alias{setRowNames.ggobi}
\alias{getRowNames.ggobi}
\title{Set or retrieve record labels.}
\description{
 Set or retrieve the names of records in a ggobi dataset.
}
\usage{
setRowNames.ggobi(names, ids=1:length(names), .data = 1, .gobi=getDefaultGGobi())
getRowNames.ggobi(.data = 1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{names}{the names to assign to the records identified by \code{ids}.
This is a character vector.}
  \item{ids}{an integer vector providing the indices of the records
 for which the \code{names} are to be assigned.}
  \item{.data}{the dataset to which these assignments or retrieval
should be applied.  This is an integer identifying to which of the
datasets to query or apply the assignment.  These start at $1$ (rather
than $0$).}
  \item{.gobi}{the ggobi instance to which these operations should be applied.}
}
\details{
 Each record in a dataset in ggobi has an associated label
or name. These functions allow the user to query these or
assign values to a subset of them.
}
\value{
 \code{getRowNames} returns a character vector 
 containing the curent values for all of the 
 records in the specified dataset within the ggobi instance.
\\
 \code{setRowNames} returns the previous names/labels of the 
specified records.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{setDataFile.ggobi}}
\code{\link{setDataFrame.ggobi}}
}

\examples{

}
\keyword{visualization}
\keyword{graphics}
