#include "RSGGobi.h"

/**
  This returns a raw pointer to the Gtk window object
  associated with the given display, which is given
  as an S object of class ggobiDisplay.
 */
USER_OBJECT_
RS_GGOBI(getDisplayWindow)(USER_OBJECT_ display)
{
    displayd *dpy;
    dpy = (displayd*) (long) NUMERIC_DATA(VECTOR_ELT(display, 1))[0];
    

    if(!dpy || GTK_IS_GGOBI_WINDOW_DISPLAY(dpy) == false)
	return(NULL_USER_OBJECT);

    return(R_MakeExternalPtr(GTK_GGOBI_WINDOW_DISPLAY(dpy)->window, Rf_install("GtkWindow"), NULL_USER_OBJECT));
}

/**
  Extracts a list of the splotd objects from the given displayd
  given as an S object of class ggobiDisplay.
  This returns the splotd objects as simple external pointers and 
  does not put a class on them.
 */
USER_OBJECT_
RS_GGOBI(getDisplayPlotWidgets)(USER_OBJECT_ display)
{
   displayd *dpy;
   int n;
   GList *tmp;
   USER_OBJECT_ els;

#if 0
    dpy =  R_ExternalPtrAddr(display);
#else
    dpy = (displayd*) (long) NUMERIC_DATA(VECTOR_ELT(display, 1))[0];
#endif

    n = g_list_length(dpy->splots);
    PROTECT(els = NEW_LIST(n));

    tmp = dpy->splots;
    n = 0;
    while(tmp) {
	USER_OBJECT_ p;
	splotd *sp = (splotd *) tmp->data; 
	p = R_MakeExternalPtr(sp->da, Rf_install("GtkWidget"), NULL_USER_OBJECT);
	SET_VECTOR_ELT(els, n++, p);
	tmp = tmp->next;
    }
    UNPROTECT(1);

    return(els);
}

